/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.util;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.item.component.StoredChargeComponent;
import net.sweenus.simplyswords.registry.ComponentTypeRegistry;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class AbilityMethods {
    public static void tickAbilityStormJolt(ItemStack stack, Level world, LivingEntity user, int ability_timer, int skillCooldown, int radius) {
        if (!user.level().isClientSide()) {
            if (ability_timer == 12 || ability_timer == 13 && HelperMethods.isHolding(stack, user)) {
                user.setDeltaMovement(user.getLookAngle().scale(4.0));
                user.setDeltaMovement(user.getDeltaMovement().x, 0.0, user.getDeltaMovement().z);
                user.hurtMarked = true;
                world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_THUNDER_SHOOT_FLYBY_03.get(), user.getSoundSource(), 0.3f, 1.6f);
                user.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 80, 1), (Entity)user);
                user.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 10, 5), (Entity)user);
                if (user instanceof Player) {
                    Player player = (Player)user;
                    player.getCooldowns().addCooldown(stack.getItem(), skillCooldown);
                }
            }
            if (ability_timer < 5 && HelperMethods.isHolding(stack, user)) {
                user.setDeltaMovement(0.0, 0.0, 0.0);
                user.hurtMarked = true;
                user.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 80, 1), (Entity)user);
            }
            if (user.tickCount % 2 == 0 && HelperMethods.isHolding(stack, user)) {
                double xpos = user.getX() - (double)(radius + 1);
                double ypos = user.getY();
                double zpos = user.getZ() - (double)(radius + 1);
                for (int i = radius * 2; i > 0; --i) {
                    for (int j = radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, xpos + (double)i + (double)choose, ypos + 0.4, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.CLOUD, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.WARPED_SPORE, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                    }
                }
            }
        }
    }

    public static void tickAbilityStorm(ItemStack stack, Level world, LivingEntity user, int ability_timer, int skillCooldown, int radius) {
        if (!user.level().isClientSide()) {
            int frequency = Config.uniqueEffects.mjolnir.frequency;
            if (user.tickCount % frequency == 0) {
                double x = user.getX();
                double y = user.getY();
                double z = user.getZ();
                user.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, frequency + 5, 5), (Entity)user);
                AABB box = new AABB(x + (double)radius, y + (double)radius, z + (double)radius, x - (double)radius, y - (double)radius, z - (double)radius);
                ServerLevel sworld = (ServerLevel)user.level();
                for (Entity entity : world.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                    LivingEntity ee;
                    float choose = (float)(Math.random() * 1.0);
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(ee = (LivingEntity)entity, user) || !((double)choose > 0.7)) continue;
                    BlockPos stormtarget = ee.blockPosition();
                    ee.addEffect(new MobEffectInstance(EffectRegistry.getReference(EffectRegistry.FREEZE), frequency + 5, 0), (Entity)user);
                    LightningBolt storm = (LightningBolt)EntityType.LIGHTNING_BOLT.spawn(sworld, stormtarget, MobSpawnType.TRIGGERED);
                    if (storm != null) {
                        storm.setVisualOnly(true);
                    }
                    ee.hurt(user.damageSources().indirectMagic((Entity)user, (Entity)user), 5.0f);
                }
            }
            if (user.tickCount % 5 == 0) {
                double xpos = user.getX() - (double)(radius + 1);
                double ypos = user.getY();
                double zpos = user.getZ() - (double)(radius + 1);
                for (int i = radius * 2; i > 0; --i) {
                    for (int j = radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.CLOUD, xpos + (double)i + (double)choose, ypos + 10.0, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public static void tickAbilityThunderBlitz(ItemStack stack, Level world, LivingEntity user, int ability_timer, int ability_timer_max, float abilityDamage, int skillCooldown, int radius) {
        if (!user.level().isClientSide()) {
            if (ability_timer > ability_timer_max - 42 && ability_timer < ability_timer_max - 40) {
                user.setDeltaMovement(user.getLookAngle().scale(6.0));
                user.setDeltaMovement(user.getDeltaMovement().x, 0.0, user.getDeltaMovement().z);
                user.hurtMarked = true;
                if (user instanceof Player) {
                    Player player = (Player)user;
                    player.getCooldowns().addCooldown(stack.getItem(), skillCooldown);
                }
                world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_THUNDER_SHOOT_IMPACT_02.get(), user.getSoundSource(), 0.3f, 1.6f);
            }
            if (ability_timer < 5) {
                user.setDeltaMovement(0.0, 0.0, 0.0);
                user.hurtMarked = true;
                user.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 80, 2), (Entity)user);
            }
            if (user.tickCount % 3 == 0 && HelperMethods.isHolding(stack, user)) {
                AABB box = new AABB(user.getX() + (double)radius, user.getY() + (double)(radius * 2), user.getZ() + (double)radius, user.getX() - (double)radius, user.getY() - (double)radius, user.getZ() - (double)radius);
                for (Entity entity : world.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                    LivingEntity le;
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user)) continue;
                    float choose = (float)(Math.random() * 1.0);
                    if (ability_timer > ability_timer_max - 40) {
                        le.hurt(world.damageSources().indirectMagic((Entity)user, (Entity)user), abilityDamage);
                        world.playSound(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_POISON_ATTACK_02.get(), le.getSoundSource(), 0.1f, choose);
                        continue;
                    }
                    if (ability_timer >= ability_timer_max - 40) continue;
                    le.hurt(world.damageSources().indirectMagic((Entity)user, (Entity)user), abilityDamage * 3.0f);
                    world.playSound(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_POISON_ATTACK_01.get(), le.getSoundSource(), 0.1f, choose);
                }
                double xpos = user.getX() - (double)(radius + 1);
                double ypos = user.getY();
                double zpos = user.getZ() - (double)(radius + 1);
                for (int i = radius * 2; i > 0; --i) {
                    for (int j = radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.ELECTRIC_SPARK, xpos + (double)i + (double)choose, ypos + 0.4, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.CLOUD, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.WARPED_SPORE, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                    }
                }
            }
        }
    }

    public static void tickAbilitySoulAnguish(ItemStack stack, Level world, LivingEntity user, float abilityDamage, int radius, double lastX, double lastY, double lastZ, float healAmount, LivingEntity abilityTarget) {
        if (!user.level().isClientSide() && abilityTarget != null) {
            float soundDistance = 0.2f - (float)user.distanceToSqr(lastX, lastY, lastZ) / 800.0f;
            if (user.tickCount % 5 != 0 || user.getItemBySlot(EquipmentSlot.MAINHAND) != stack) {
                return;
            }
            AABB box = new AABB(lastX + (double)radius, lastY + (double)radius, lastZ + (double)radius, lastX - (double)radius, lastY - (double)radius, lastZ - (double)radius);
            for (Entity entity : world.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entity;
                if (!HelperMethods.checkFriendlyFire((LivingEntity)entity, user)) continue;
                float choose = (float)(Math.random() * 1.0);
                if (user.getRandom().nextInt(100) <= 8) {
                    world.playSound(null, (Entity)le, (SoundEvent)SoundRegistry.DARK_SWORD_BREAKS.get(), le.getSoundSource(), soundDistance, choose);
                    user.heal(healAmount);
                }
                stack.update((DataComponentType)ComponentTypeRegistry.STORED_CHARGE.get(), (Object)StoredChargeComponent.DEFAULT, StoredChargeComponent::increment);
                le.hurt(user.damageSources().indirectMagic((Entity)user, (Entity)user), abilityDamage);
            }
            world.playSeededSound(null, lastX, lastY, lastZ, (SoundEvent)SoundRegistry.DARK_SWORD_BLOCK.get(), user.getSoundSource(), soundDistance, 0.3f, 100L);
            double xPos = lastX - (double)(radius + 1);
            double yPos = lastY;
            double zPos = lastZ - (double)(radius + 1);
            world.playLocalSound(xPos, yPos, zPos, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_ICE_SHOOT_IMPACT_03.get(), user.getSoundSource(), 0.1f, 0.2f, true);
            for (int i = radius * 2; i > 0; --i) {
                for (int j = radius * 2; j > 0; --j) {
                    float choose = (float)(Math.random() * 1.0);
                    HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.MYCELIUM, xPos + (double)i + (double)choose, yPos, zPos + (double)j + (double)choose, choose / 3.0f, -0.3, choose / 3.0f);
                    choose = (float)(Math.random() * 1.0);
                    HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.SOUL, xPos + (double)i + (double)choose, yPos, zPos + (double)j + (double)choose, choose / 3.0f, 0.0, choose / 3.0f);
                }
            }
        }
    }

    public static void tickAbilityPermafrost(ItemStack stack, Level world, LivingEntity user, int ability_timer, float abilityDamage, int radius, double lastX, double lastY, double lastZ) {
        if (user.level().isClientSide()) {
            return;
        }
        int rradius = radius * 2;
        if (ability_timer < 5) {
            user.releaseUsingItem();
        }
        if (user.tickCount % 10 != 0 || !HelperMethods.isHolding(stack, user)) {
            return;
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            player.getFoodData().addExhaustion(0.8f);
        }
        AABB box = new AABB(user.getX() + (double)rradius, user.getY() + (double)radius, user.getZ() + (double)rradius, user.getX() - (double)rradius, user.getY() - (double)radius, user.getZ() - (double)rradius);
        for (Entity entity : world.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
            LivingEntity le;
            if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user)) continue;
            if (le.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
                int a = le.getEffect(MobEffects.MOVEMENT_SLOWDOWN).getAmplifier() + 1;
                if (a < 4) {
                    le.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, a), (Entity)user);
                } else {
                    le.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, a - 1), (Entity)user);
                }
            } else {
                le.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 0), (Entity)user);
            }
            float choose = (float)(Math.random() * 1.0);
            world.playSound(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_ICE_SHOOT_IMPACT_03.get(), user.getSoundSource(), 0.1f, choose);
            le.hurt(world.damageSources().indirectMagic((Entity)user, (Entity)user), abilityDamage * 3.0f);
        }
        double xpos = lastX - (double)(rradius + 1);
        double ypos = lastY;
        double zpos = lastZ - (double)(rradius + 1);
        world.playLocalSound(xpos, ypos, zpos, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_ICE_SHOOT_IMPACT_03.get(), user.getSoundSource(), 0.1f, 0.2f, true);
        for (int i = rradius * 2; i > 0; --i) {
            for (int j = rradius * 2; j > 0; --j) {
                float choose = (float)(Math.random() * 1.0);
                HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.SNOWFLAKE, xpos + (double)i + (double)choose, ypos + 6.0, zpos + (double)j + (double)choose, choose / 3.0f, -0.3, choose / 3.0f);
                choose = (float)(Math.random() * 1.0);
                HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.WHITE_ASH, xpos + (double)i + (double)choose, ypos + 6.0, zpos + (double)j + (double)choose, choose / 3.0f, 0.0, choose / 3.0f);
            }
        }
    }

    public static void tickAbilityArcaneAssault(ItemStack stack, Level world, LivingEntity user, int ability_timer, float abilityDamage, int radius) {
        if (!user.level().isClientSide()) {
            if (ability_timer < 5) {
                user.releaseUsingItem();
            }
            if (user.tickCount % 10 == 0 && HelperMethods.isHolding(stack, user)) {
                AABB box = new AABB(user.getX() + (double)radius, user.getY() + (double)(radius * 2), user.getZ() + (double)radius, user.getX() - (double)radius, user.getY() - (double)radius, user.getZ() - (double)radius);
                for (Entity entity : world.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                    LivingEntity le;
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user)) continue;
                    float choose = (float)(Math.random() * 1.0);
                    if (!le.hasEffect(MobEffects.LEVITATION) && ability_timer > 30) {
                        le.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 20, 1), (Entity)user);
                        world.playSound(null, (Entity)le, (SoundEvent)SoundRegistry.MAGIC_BOW_SHOOT_IMPACT_03.get(), le.getSoundSource(), 0.1f, choose);
                    }
                    le.hurt(world.damageSources().indirectMagic((Entity)user, (Entity)user), abilityDamage);
                    if (ability_timer >= 10) continue;
                    le.removeEffect(MobEffects.LEVITATION);
                    le.hurt(world.damageSources().indirectMagic((Entity)user, (Entity)user), abilityDamage * 3.0f);
                    le.setDeltaMovement(0.0, -10.0, 0.0);
                    user.releaseUsingItem();
                    world.playSound(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_SCIFI_ATTACK_03.get(), le.getSoundSource(), 0.3f, choose);
                }
                world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_BOW_CHARGE_SHORT_VERSION.get(), user.getSoundSource(), 0.1f, 0.6f);
                double xpos = user.getX() - (double)(radius + 1);
                double ypos = user.getY();
                double zpos = user.getZ() - (double)(radius + 1);
                for (int i = radius * 2; i > 0; --i) {
                    for (int j = radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.DRAGON_BREATH, xpos + (double)i + (double)choose, ypos + 0.4, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.PORTAL, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.REVERSE_PORTAL, xpos + (double)i + (double)choose, ypos + 1.0, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                    }
                }
            }
        }
    }

    public static void tickAbilityVolcanicFury(ItemStack stack, Level world, LivingEntity user, int ability_timer, int ability_timer_max, float abilityDamage, int skillCooldown, int radius, int chargePower) {
        if (!user.level().isClientSide()) {
            if (ability_timer < 5) {
                user.releaseUsingItem();
            }
            if (user.tickCount % 20 == 0 && HelperMethods.isHolding(stack, user)) {
                if (ability_timer > 10) {
                    Player player;
                    user.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 5), (Entity)user);
                    user.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 20, 5), (Entity)user);
                    user.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 20, 5), (Entity)user);
                    world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_EARTH_SHOOT_IMPACT_02.get(), user.getSoundSource(), 0.8f, 0.1f * (float)chargePower);
                    if (!(!(user.getHealth() > 2.0f) || user instanceof Player && (player = (Player)user).isCreative())) {
                        user.setHealth(user.getHealth() - 1.0f);
                    }
                }
                AABB box = new AABB(user.getX() + (double)(radius * 8), user.getY() + (double)radius, user.getZ() + (double)(radius * 8), user.getX() - (double)(radius * 8), user.getY() - (double)radius, user.getZ() - (double)(radius * 8));
                for (Entity entity : world.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                    LivingEntity le;
                    if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, user) || ability_timer <= 12) continue;
                    le.hurt(world.damageSources().indirectMagic((Entity)user, (Entity)user), abilityDamage);
                    le.setDeltaMovement((user.getX() - le.getX()) / 10.0, (user.getY() - le.getY()) / 10.0, (user.getZ() - le.getZ()) / 10.0);
                    le.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 3), (Entity)user);
                }
                double xpos = user.getX() - (double)(radius + 1);
                double ypos = user.getY();
                double zpos = user.getZ() - (double)(radius + 1);
                for (int i = radius * 2; i > 0; --i) {
                    for (int j = radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.WARPED_SPORE, xpos + (double)i + (double)choose, ypos + 0.4, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.LAVA, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                    }
                }
            }
        }
    }

    public static void astralShiftSounds(ServerPlayer serverPlayer) {
        SoundEvent[] soundOptions = new SoundEvent[]{(SoundEvent)SoundRegistry.DISTORTION_ARC_01.get(), (SoundEvent)SoundRegistry.DISTORTION_ARC_02.get(), (SoundEvent)SoundRegistry.DISTORTION_ARC_03.get()};
        Random random = new Random();
        SoundEvent soundRandom = soundOptions[random.nextInt(soundOptions.length)];
        serverPlayer.level().playSound(null, (Entity)serverPlayer, soundRandom, SoundSource.PLAYERS, 0.7f, 0.5f + (float)serverPlayer.getRandom().nextIntBetweenInclusive(1, 5) * 0.1f);
    }

    public static boolean astralShiftPassive(ServerPlayer serverPlayer) {
        return serverPlayer.getRandom().nextInt(100) < Config.uniqueEffects.caelestis.chance;
    }

    public static void applyAxolotlBuff(ServerPlayer player, CompoundTag axolotlDataLeft, CompoundTag axolotlDataRight) {
        boolean hasRightAxolotl;
        boolean hasLeftAxolotl = axolotlDataLeft != null && axolotlDataLeft.contains("Variant");
        boolean bl = hasRightAxolotl = axolotlDataRight != null && axolotlDataRight.contains("Variant");
        if (!hasLeftAxolotl && !hasRightAxolotl) {
            return;
        }
        if (player.tickCount % 40 == 0) {
            MobEffectInstance mobEffectInstance;
            MobEffectInstance leftSecondaryEffect;
            MobEffectInstance mobEffectInstance2;
            int amplifierBoost;
            AABB area = new AABB(player.getX() - 5.0, player.getY() - 3.0, player.getZ() - 5.0, player.getX() + 5.0, player.getY() + 3.0, player.getZ() + 5.0);
            int leftVariant = hasLeftAxolotl ? axolotlDataLeft.getInt("Variant") : -1;
            int rightVariant = hasRightAxolotl ? axolotlDataRight.getInt("Variant") : -1;
            boolean areVariantsMatching = hasLeftAxolotl && hasRightAxolotl && leftVariant == rightVariant;
            int n = amplifierBoost = areVariantsMatching ? 1 : 0;
            if (hasLeftAxolotl) {
                switch (leftVariant) {
                    case 0: {
                        mobEffectInstance2 = new MobEffectInstance(MobEffects.REGENERATION, 80, amplifierBoost, false, false, true);
                        break;
                    }
                    case 1: {
                        mobEffectInstance2 = new MobEffectInstance(MobEffects.NIGHT_VISION, 80, amplifierBoost, false, false, true);
                        break;
                    }
                    case 2: {
                        mobEffectInstance2 = new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 50, amplifierBoost, false, false, true);
                        break;
                    }
                    case 3: {
                        mobEffectInstance2 = new MobEffectInstance(MobEffects.DAMAGE_BOOST, 50, amplifierBoost, false, false, true);
                        break;
                    }
                    case 4: {
                        mobEffectInstance2 = new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 50, amplifierBoost, false, false, true);
                        break;
                    }
                    default: {
                        mobEffectInstance2 = null;
                        break;
                    }
                }
            } else {
                mobEffectInstance2 = null;
            }
            MobEffectInstance leftPrimaryEffect = mobEffectInstance2;
            MobEffectInstance mobEffectInstance3 = leftSecondaryEffect = hasLeftAxolotl && leftVariant == 4 ? new MobEffectInstance(MobEffects.LUCK, 50, amplifierBoost, false, false, true) : null;
            if (hasRightAxolotl) {
                switch (rightVariant) {
                    case 0: {
                        mobEffectInstance = new MobEffectInstance(MobEffects.REGENERATION, 80, amplifierBoost, false, false, true);
                        break;
                    }
                    case 1: {
                        mobEffectInstance = new MobEffectInstance(MobEffects.NIGHT_VISION, 80, amplifierBoost, false, false, true);
                        break;
                    }
                    case 2: {
                        mobEffectInstance = new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 50, amplifierBoost, false, false, true);
                        break;
                    }
                    case 3: {
                        mobEffectInstance = new MobEffectInstance(MobEffects.DAMAGE_BOOST, 50, amplifierBoost, false, false, true);
                        break;
                    }
                    case 4: {
                        mobEffectInstance = new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 50, amplifierBoost, false, false, true);
                        break;
                    }
                    default: {
                        mobEffectInstance = null;
                        break;
                    }
                }
            } else {
                mobEffectInstance = null;
            }
            MobEffectInstance rightPrimaryEffect = mobEffectInstance;
            MobEffectInstance rightSecondaryEffect = hasRightAxolotl && rightVariant == 4 ? new MobEffectInstance(MobEffects.LUCK, 50, amplifierBoost, false, false, true) : null;
            List entities = player.level().getEntitiesOfClass(Player.class, area, entity -> true);
            for (Player entity2 : entities) {
                if (leftPrimaryEffect != null) {
                    entity2.addEffect(new MobEffectInstance(leftPrimaryEffect));
                }
                if (leftSecondaryEffect != null) {
                    entity2.addEffect(new MobEffectInstance(leftSecondaryEffect));
                }
                if (rightPrimaryEffect != null) {
                    entity2.addEffect(new MobEffectInstance(rightPrimaryEffect));
                }
                if (rightSecondaryEffect == null) continue;
                entity2.addEffect(new MobEffectInstance(rightSecondaryEffect));
            }
        }
        int frequency = player.getRandom().nextInt(10);
        Level world = player.level();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (player.tickCount % 8 + frequency == 0 && hasLeftAxolotl) {
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.FALLING_DRIPSTONE_WATER, player.getX() - 0.3, player.getY() + 1.3, player.getZ(), 5, 0.1, 0.1, 0.1, 0.03);
            }
            if (player.tickCount % 10 + (frequency = player.getRandom().nextInt(10)) == 0 && hasRightAxolotl) {
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.FALLING_DRIPSTONE_WATER, player.getX() + 0.3, player.getY() + 1.3, player.getZ(), 5, 0.1, 0.1, 0.1, 0.03);
            }
            if (player.tickCount % 10 + (frequency = player.getRandom().nextInt(30)) == 0) {
                world.playSound(null, (Entity)player, SoundEvents.AXOLOTL_IDLE_AIR, player.getSoundSource(), 1.0f, 1.0f);
            }
        }
    }
}

