/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.power.powers;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.annotations.Translation;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.power.RunefusedGemPower;
import net.sweenus.simplyswords.registry.GemPowerRegistry;
import net.sweenus.simplyswords.util.Styles;

public class UnstablePower
extends RunefusedGemPower {
    public UnstablePower() {
        super(false);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, LivingEntity user, int slot, boolean selected) {
        int duration = Config.gemPowers.unstable.duration;
        int frequency = Config.gemPowers.unstable.frequency;
        if (user.tickCount % frequency == 0) {
            int random = (int)(Math.random() * 100.0);
            if (random < 10) {
                user.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, duration));
            } else if (random < 20) {
                user.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, duration));
            } else if (random < 30) {
                user.addEffect(new MobEffectInstance(MobEffects.REGENERATION, duration));
            } else if (random < 40) {
                user.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, duration));
            } else if (random < 50) {
                user.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, duration));
            } else if (random < 60) {
                user.addEffect(new MobEffectInstance(MobEffects.JUMP, duration));
            } else if (random < 70) {
                user.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, duration));
            } else if (random < 80) {
                user.addEffect(new MobEffectInstance(MobEffects.DOLPHINS_GRACE, duration));
            } else if (random < 90) {
                user.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, duration));
            } else if (random < 95) {
                user.addEffect(new MobEffectInstance(MobEffects.LEVITATION, duration));
            } else if (random < 100) {
                user.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, duration));
            }
        }
    }

    @Override
    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type, boolean isRunic) {
        if (isRunic) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.unstablesworditem.tooltip1").setStyle(Styles.RUNIC));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.runefused_power.unstable").setStyle(Styles.RUNIC));
        }
        if (TooltipUtils.shouldDisplayTooltip(itemStack, null)) {
            tooltip.add((Component)Component.translatable((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.unstablesworditem.tooltip2").setStyle(Styles.RUNIC_DESCRIPTION)));
            tooltip.add((Component)Component.translatable((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.unstablesworditem.tooltip3").setStyle(Styles.RUNIC_DESCRIPTION)));
        }
    }

    public static class Settings
    extends TooltipSettings {
        @Translation(prefix="simplyswords.config.basic_settings")
        @ValidatedInt.Restrict(min=1)
        public int frequency = 140;
        @Translation(prefix="simplyswords.config.basic_settings")
        @ValidatedInt.Restrict(min=0)
        public int duration = 140;

        public Settings() {
            super((Supplier<? extends TooltipProvider>)GemPowerRegistry.UNSTABLE);
        }
    }
}

