/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.power;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.power.PowerType;
import net.sweenus.simplyswords.registry.GemPowerRegistry;

public class GemPower
implements TooltipProvider {
    private final boolean isGreater;
    private final List<PowerType> applicableTypes;
    public static GemPower EMPTY = new EmptyGemPower();

    public GemPower(boolean isGreater, PowerType ... applicableTypes) {
        this.isGreater = isGreater;
        this.applicableTypes = Arrays.stream(applicableTypes).toList();
    }

    public boolean isGreater() {
        return this.isGreater;
    }

    public List<PowerType> applicableTypes() {
        return this.applicableTypes;
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag type) {
        ArrayList<Component> list = new ArrayList<Component>();
        this.appendTooltip(ItemStack.EMPTY, context, list, type, false);
        for (Component text : list) {
            tooltip.accept(text);
        }
    }

    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type, boolean isRunic) {
    }

    public void postHit(ItemStack stack, LivingEntity target, LivingEntity attacker) {
    }

    public void inventoryTick(ItemStack stack, Level world, LivingEntity user, int slot, boolean selected) {
    }

    InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand, ItemStack itemStack) {
        return InteractionResultHolder.fail((Object)itemStack);
    }

    void usageTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
    }

    void onStoppedUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
    }

    int getMaxUseTime(ItemStack stack) {
        return 0;
    }

    public boolean isEmpty() {
        return false;
    }

    private static class EmptyGemPower
    extends GemPower {
        public EmptyGemPower() {
            super(false, new PowerType[0]);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    public static final class GemPowerCodec
    implements Codec<Holder<GemPower>> {
        public <T> DataResult<Pair<Holder<GemPower>, T>> decode(DynamicOps<T> ops, T input) {
            return ResourceLocation.CODEC.decode(ops, input).flatMap(pair -> {
                ResourceLocation identifier = (ResourceLocation)pair.getFirst();
                Holder entry = GemPowerRegistry.REGISTRY.getHolder(identifier);
                if (entry != null) {
                    return DataResult.success((Object)Pair.of((Object)entry, (Object)pair.getSecond()));
                }
                return DataResult.error(() -> "Unknown decoded power type " + String.valueOf(input) + " in registry " + String.valueOf(GemPowerRegistry.REGISTRY.key()));
            });
        }

        public <T> DataResult<T> encode(Holder<GemPower> input, DynamicOps<T> ops, T prefix) {
            try {
                ResourceLocation id = GemPowerRegistry.REGISTRY.getId((Object)((GemPower)input.value()));
                if (id == null) {
                    return DataResult.error(() -> "Unknown encoded power type " + String.valueOf(input) + " in registry " + String.valueOf(GemPowerRegistry.REGISTRY.key()));
                }
                return ResourceLocation.CODEC.encode((Object)id, ops, prefix);
            }
            catch (Throwable e) {
                return DataResult.error(() -> "Can't access registry " + String.valueOf(GemPowerRegistry.REGISTRY.key()));
            }
        }
    }
}

