/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.mixin;

import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.LootConfig;
import net.sweenus.simplyswords.item.ContainedRemnantItem;
import net.sweenus.simplyswords.item.RunicTabletItem;
import net.sweenus.simplyswords.item.custom.CaelestisSwordItem;
import net.sweenus.simplyswords.item.custom.DormantRelicSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.AbilityMethods;
import net.sweenus.simplyswords.util.HelperMethods;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin {
    @Shadow
    public abstract ServerLevel serverLevel();

    @Inject(at={@At(value="HEAD")}, method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, cancellable=true)
    public void simplyswords$damage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        if (player instanceof ServerPlayer) {
            int duration;
            MobEffectInstance astralShiftInstance;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.hasEffect(EffectRegistry.getReference(EffectRegistry.RESILIENCE))) {
                HelperMethods.decrementStatusEffect((LivingEntity)serverPlayer, EffectRegistry.getReference(EffectRegistry.RESILIENCE));
                cir.setReturnValue((Object)false);
                if (player.hasEffect(EffectRegistry.getReference(EffectRegistry.RIBBONCLEAVE))) {
                    serverPlayer.level().playSound(null, (Entity)serverPlayer, (SoundEvent)SoundRegistry.MAGIC_SWORD_PARRY_03.get(), SoundSource.PLAYERS, 0.7f, 0.5f + (float)serverPlayer.getRandom().nextIntBetweenInclusive(1, 5) * 0.1f);
                }
            }
            if (serverPlayer.hasEffect(EffectRegistry.getReference(EffectRegistry.ASTRAL_SHIFT)) && (astralShiftInstance = player.getEffect(EffectRegistry.getReference(EffectRegistry.ASTRAL_SHIFT))) != null && (duration = astralShiftInstance.getDuration()) > 10) {
                HelperMethods.incrementStatusEffect((LivingEntity)serverPlayer, EffectRegistry.getReference(EffectRegistry.ASTRAL_SHIFT), duration, (int)Math.max(1.0f, amount / 10.0f), 99);
                AbilityMethods.astralShiftSounds(serverPlayer);
                cir.setReturnValue((Object)false);
            }
            if (serverPlayer.getMainHandItem().getItem() instanceof CaelestisSwordItem && AbilityMethods.astralShiftPassive(serverPlayer)) {
                AbilityMethods.astralShiftSounds(serverPlayer);
                cir.setReturnValue((Object)false);
            }
            if (source.toString().contains("sonic_boom")) {
                for (int i = 0; i < serverPlayer.getInventory().getContainerSize(); ++i) {
                    ItemStack stackInSlot = serverPlayer.getInventory().getItem(i);
                    if (!stackInSlot.is((Item)ItemsRegistry.DECAYING_RELIC.get())) continue;
                    ItemStack newItemStack = new ItemStack((ItemLike)ItemsRegistry.MAGISCYTHE.get());
                    newItemStack.applyComponents(stackInSlot.getComponents());
                    serverPlayer.getInventory().setItem(i, newItemStack);
                    serverPlayer.level().playSound(null, (Entity)serverPlayer, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_02.get(), serverPlayer.getSoundSource(), 0.6f, 0.6f);
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"item.simplyswords.magicythe.event"), true);
                    break;
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    public void simplyswords$tick(CallbackInfo ci) {
        Player player = (Player)this;
        if (player instanceof ServerPlayer) {
            int chance;
            int frequency;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.getMainHandItem().is((Item)ItemsRegistry.RIBBONCLEAVER.get()) || serverPlayer.getMainHandItem().is((Item)ItemsRegistry.ENIGMA.get())) {
                frequency = 6;
                if (serverPlayer.tickCount % 20 == 0 && serverPlayer.getMainHandItem().is((Item)ItemsRegistry.RIBBONCLEAVER.get())) {
                    serverPlayer.addEffect(new MobEffectInstance(EffectRegistry.getReference(EffectRegistry.RIBBONWRATH), 30, 0, true, false, false));
                }
                if (player.tickCount % frequency == 0 && player.isSprinting() && player.onGround()) {
                    float volume = 0.3f;
                    float pitch = 1.0f + (float)player.getRandom().nextIntBetweenInclusive(1, 5) * 0.1f;
                    player.level().playSound(null, player.blockPosition(), (SoundEvent)SoundRegistry.OBJECT_IMPACT_THUD.get(), SoundSource.PLAYERS, volume, pitch);
                }
            }
            if (serverPlayer.getMainHandItem().is((Item)ItemsRegistry.MAGIBLADE.get())) {
                frequency = 8;
                double radius = Config.uniqueEffects.magiblade.repelRadius;
                chance = Config.uniqueEffects.magiblade.repelChance;
                int totalChance = new Random().nextInt(100);
                if (serverPlayer.tickCount % frequency == 0 && totalChance < chance) {
                    LivingEntity le;
                    AABB box = HelperMethods.createBox((Entity)player, radius);
                    Entity closestEntity = player.level().getEntities((Entity)player, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE).stream().filter(entity -> {
                        if (entity instanceof LivingEntity) {
                            LivingEntity livingEntity = (LivingEntity)entity;
                            return HelperMethods.checkFriendlyFire(livingEntity, (LivingEntity)player);
                        }
                        return false;
                    }).min(Comparator.comparingDouble(entity -> entity.distanceToSqr((Entity)player))).orElse(null);
                    if (closestEntity != null && closestEntity instanceof LivingEntity && (le = (LivingEntity)closestEntity).distanceTo((Entity)player) > 1.0f) {
                        closestEntity.setDeltaMovement((closestEntity.getX() - player.getX()) / 2.0, 0.0, (closestEntity.getZ() - player.getZ()) / 2.0);
                        float volume = 0.8f;
                        float pitch = 1.0f + (float)player.getRandom().nextIntBetweenInclusive(1, 5) * 0.1f;
                        player.level().playSound(null, player.blockPosition(), SoundEvents.SCULK_CLICKING, SoundSource.PLAYERS, volume, pitch);
                        HelperMethods.spawnWaistHeightParticles((ServerLevel)player.level(), (ParticleOptions)ParticleTypes.ENCHANT, closestEntity, (Entity)player, 10);
                        HelperMethods.spawnOrbitParticles((ServerLevel)closestEntity.level(), closestEntity.position().add(0.0, (double)(closestEntity.getBbHeight() / 2.0f), 0.0), (ParticleOptions)ParticleTypes.SCULK_CHARGE_POP, 0.5, 6);
                    }
                }
            }
            if (serverPlayer.tickCount % (frequency = Config.general.containedRemnantTransformFrequency) == 0) {
                ItemStack containedRemnant = ((ContainedRemnantItem)((Object)ItemsRegistry.CONTAINED_REMNANT.get())).asItem().getDefaultInstance();
                ItemStack tamperedRemnant = ((ContainedRemnantItem)((Object)ItemsRegistry.TAMPERED_REMNANT.get())).asItem().getDefaultInstance();
                ItemStack decayingRelic = ((DormantRelicSwordItem)((Object)ItemsRegistry.DECAYING_RELIC.get())).asItem().getDefaultInstance();
                ItemStack runicTablet = ((RunicTabletItem)((Object)ItemsRegistry.RUNIC_TABLET.get())).asItem().getDefaultInstance();
                Random random = new Random();
                TagKey desiredItemsTag = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"simplyswords", (String)"conditional_uniques_type_1"));
                TagKey endItemsTag = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"simplyswords", (String)"conditional_uniques_type_2"));
                int chance2 = random.nextInt(100);
                for (int i = 0; i < serverPlayer.getInventory().getContainerSize(); ++i) {
                    ItemStack stackInSlot = serverPlayer.getInventory().getItem(i);
                    if ((stackInSlot.is(containedRemnant.getItem()) || stackInSlot.is(tamperedRemnant.getItem())) && chance2 < 36 && ((Boolean)LootConfig.INSTANCE.enableContainedRemnants.get()).booleanValue()) {
                        List<Item> itemsFromTag = BuiltInRegistries.ITEM.stream().filter(item -> item.getDefaultInstance().is(desiredItemsTag)).toList();
                        List<Item> itemsFromTagEnd = BuiltInRegistries.ITEM.stream().filter(item -> item.getDefaultInstance().is(endItemsTag)).toList();
                        if (!itemsFromTag.isEmpty() && !itemsFromTagEnd.isEmpty()) {
                            Item randomItem = (Item)ItemsRegistry.TAMPERED_REMNANT.get();
                            if (serverPlayer.level().dimension().equals(Level.END) && serverPlayer.getInventory().getItem(i).is(containedRemnant.getItem()) && serverPlayer.getInventory().contains(runicTablet)) {
                                serverPlayer.level().playSound(null, (Entity)serverPlayer, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_03.get(), serverPlayer.getSoundSource(), 0.3f, 0.6f);
                                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"item.simplyswords.contained_remnant.event2"), true);
                            } else {
                                if (serverPlayer.getInventory().getItem(i).is((Item)ItemsRegistry.CONTAINED_REMNANT.get())) {
                                    randomItem = itemsFromTag.get(random.nextInt(itemsFromTag.size()));
                                } else if (serverPlayer.getInventory().getItem(i).is((Item)ItemsRegistry.TAMPERED_REMNANT.get())) {
                                    randomItem = itemsFromTagEnd.get(random.nextInt(itemsFromTagEnd.size()));
                                }
                                serverPlayer.level().playSound(null, (Entity)serverPlayer, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_02.get(), serverPlayer.getSoundSource(), 0.3f, 0.6f);
                                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"item.simplyswords.contained_remnant.event"), true);
                            }
                            ItemStack newItemStack = new ItemStack((ItemLike)randomItem);
                            serverPlayer.getInventory().setItem(i, newItemStack);
                            break;
                        }
                    }
                    BlockState playerStandingBlock = serverPlayer.getBlockStateOn();
                    if (stackInSlot.is(decayingRelic.getItem()) && playerStandingBlock.is(Blocks.SCULK)) {
                        serverPlayer.sendSystemMessage((Component)Component.translatable((String)"item.simplyswords.magicythe.event2"), true);
                    }
                    if (!stackInSlot.is(decayingRelic.getItem()) || !playerStandingBlock.is(Blocks.SCULK_SENSOR)) continue;
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"item.simplyswords.magiblade.event2"), true);
                }
            }
            if (serverPlayer.tickCount % 20 == 0) {
                BlockState playerStandingBlock = serverPlayer.getBlockStateOn();
                ItemStack decayingRelic = ((DormantRelicSwordItem)((Object)ItemsRegistry.DECAYING_RELIC.get())).asItem().getDefaultInstance();
                chance = new Random().nextInt(100);
                for (int i = 0; i < serverPlayer.getInventory().getContainerSize(); ++i) {
                    ItemStack newItemStack;
                    ItemStack stackInSlot = serverPlayer.getInventory().getItem(i);
                    if (chance < 15 && playerStandingBlock.is(Blocks.SCULK_SENSOR) && stackInSlot.is(decayingRelic.getItem())) {
                        newItemStack = new ItemStack((ItemLike)ItemsRegistry.MAGIBLADE.get());
                        newItemStack.applyComponents(stackInSlot.getComponents());
                        serverPlayer.getInventory().setItem(i, newItemStack);
                        serverPlayer.level().playSound(null, (Entity)serverPlayer, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_02.get(), serverPlayer.getSoundSource(), 0.6f, 0.6f);
                        serverPlayer.sendSystemMessage((Component)Component.translatable((String)"item.simplyswords.magiblade.event"), true);
                        break;
                    }
                    if (!stackInSlot.is(decayingRelic.getItem()) || !player.hasEffect(MobEffects.DARKNESS)) continue;
                    if (chance < 2) {
                        newItemStack = new ItemStack((ItemLike)ItemsRegistry.MAGISPEAR.get());
                        newItemStack.applyComponents(stackInSlot.getComponents());
                        serverPlayer.getInventory().setItem(i, newItemStack);
                        serverPlayer.level().playSound(null, (Entity)serverPlayer, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_SCIFI_SHOOT_IMPACT_02.get(), serverPlayer.getSoundSource(), 0.6f, 0.6f);
                        serverPlayer.sendSystemMessage((Component)Component.translatable((String)"item.simplyswords.magispear.event"), true);
                        break;
                    }
                    if (chance >= 11) continue;
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"item.simplyswords.magispear.event2"), true);
                }
            }
            CompoundTag leftShoulder = player.getShoulderEntityLeft();
            CompoundTag rightShoulder = player.getShoulderEntityRight();
            AbilityMethods.applyAxolotlBuff(serverPlayer, leftShoulder, rightShoulder);
            if (HelperMethods.isHoldingItem((Item)ItemsRegistry.CHOMPOLOTL.get(), (LivingEntity)serverPlayer) && Config.general.enablePassiveParticles) {
                HelperMethods.createServerBubbleTrail(this.serverLevel(), serverPlayer);
            }
            if (HelperMethods.isHoldingItem((Item)ItemsRegistry.CONTAINED_REMNANT.get(), (LivingEntity)serverPlayer)) {
                ContainedRemnantItem.checkNearbyBlocks(serverPlayer);
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"attack(Lnet/minecraft/world/entity/Entity;)V"})
    public void simplyswords$attack(Entity target, CallbackInfo ci) {
        Player player = (Player)this;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (target.isAttackable() && target instanceof LivingEntity && !target.skipAttackInteraction((Entity)player)) {
                ServerLevel serverWorld = (ServerLevel)player.level();
                if (serverPlayer.hasEffect(EffectRegistry.getReference(EffectRegistry.RIBBONCLEAVE))) {
                    serverPlayer.removeEffect(EffectRegistry.getReference(EffectRegistry.RIBBONCLEAVE));
                    HelperMethods.spawnOrbitParticles(serverWorld, target.position().add(0.0, 0.3, 0.0), (ParticleOptions)ParticleTypes.POOF, 0.5, 6);
                    HelperMethods.spawnOrbitParticles(serverWorld, target.position().add(0.0, 0.5, 0.0), (ParticleOptions)ParticleTypes.ENCHANTED_HIT, 0.5, 6);
                    serverWorld.playSound(null, target.blockPosition(), (SoundEvent)SoundRegistry.MAGIC_SWORD_PARRY_01.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
                }
            }
        }
    }
}

