/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.entity.LivyatanEntity;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class LivyatanSwordItem
extends UniqueSwordItem {
    public LivyatanSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker.level().isClientSide()) {
            return super.hurtEnemy(stack, target, attacker);
        }
        HelperMethods.playHitSounds(attacker, target);
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        float abilityDamage = HelperMethods.spellScaledDamage("frost", (Entity)user, Config.uniqueEffects.livyatan.spellScaling, Config.uniqueEffects.livyatan.damage);
        int duration = Config.uniqueEffects.livyatan.duration;
        float returnDamage = Config.uniqueEffects.livyatan.returnDamage;
        double radius = Config.uniqueEffects.livyatan.radius;
        ItemStack itemStack = user.getItemInHand(hand);
        if (!world.isClientSide) {
            itemStack = user.getItemInHand(hand);
            LivyatanEntity livyatanEntity = new LivyatanEntity(world, (LivingEntity)user, itemStack.copy());
            livyatanEntity.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), 0.0f, 1.5f, 1.0f);
            livyatanEntity.setYRot(user.getYRot());
            livyatanEntity.setXRot(user.getXRot());
            livyatanEntity.primaryBaseDamage = abilityDamage;
            livyatanEntity.slownessDuration = duration;
            livyatanEntity.primaryReturnDamage = returnDamage;
            livyatanEntity.primaryReturnDamageRadius = radius;
            if (hand == InteractionHand.OFF_HAND) {
                livyatanEntity.offhandThrow = true;
            }
            livyatanEntity.setPosRaw(user.getX(), user.getEyeY() - 0.5, user.getZ());
            world.addFreshEntity((Entity)livyatanEntity);
            if (!user.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
        }
        user.swing(hand);
        user.getCooldowns().addCooldown((Item)this, 1);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.SNOWFLAKE, (ParticleOptions)ParticleTypes.SNOWFLAKE, (ParticleOptions)ParticleTypes.WHITE_ASH, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.livyatansworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.livyatansworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.livyatansworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.livyatansworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.livyatansworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.livyatansworditem.tooltip5").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "frost");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedFloat.Restrict(min=0.0f)
        public float returnDamage;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damage;
        @ValidatedInt.Restrict(min=0)
        public int duration;
        @ValidatedDouble.Restrict(min=0.5)
        public double radius;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.LIVYATAN.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.returnDamage = 8.0f;
            this.damage = 8.0f;
            this.duration = 100;
            this.radius = 0.5;
            this.spellScaling = 1.7f;
        }
    }
}

