/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.TwoHandedWeapon;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.component.ChargedLocationComponent;
import net.sweenus.simplyswords.registry.ComponentTypeRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.AbilityMethods;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class IcewhisperSwordItem
extends UniqueSwordItem
implements TwoHandedWeapon {
    public IcewhisperSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        HelperMethods.playHitSounds(attacker, target);
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        itemStack.set((DataComponentType)ComponentTypeRegistry.CHARGED_LOCATION.get(), (Object)new ChargedLocationComponent(user.getX(), user.getY(), user.getZ()));
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (HelperMethods.isHolding(stack, user) && user instanceof Player) {
            ChargedLocationComponent location = (ChargedLocationComponent)stack.getOrDefault((DataComponentType)ComponentTypeRegistry.CHARGED_LOCATION.get(), (Object)ChargedLocationComponent.DEFAULT);
            int radius = Config.uniqueEffects.icewhisper.radius;
            float abilityDamage = HelperMethods.spellScaledDamage("frost", (Entity)user, Config.uniqueEffects.icewhisper.spellScaling, Config.uniqueEffects.icewhisper.damage);
            AbilityMethods.tickAbilityPermafrost(stack, world, user, remainingUseTicks, abilityDamage, radius, location.lastX(), location.lastY(), location.lastZ());
        }
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return Config.uniqueEffects.icewhisper.duration;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!world.isClientSide && user instanceof Player) {
            Player player = (Player)user;
            int skillCooldown = Config.uniqueEffects.icewhisper.cooldown;
            player.getCooldowns().addCooldown(stack.getItem(), skillCooldown);
        }
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            int radius = Config.uniqueEffects.icewhisper.radius;
            if (player.tickCount % 35 == 0 && player.getItemBySlot(EquipmentSlot.MAINHAND) == stack) {
                AABB box = new AABB(player.getX() + (double)radius, player.getY() + (double)radius, player.getZ() + (double)radius, player.getX() - (double)radius, player.getY() - (double)radius, player.getZ() - (double)radius);
                for (Entity otherEntity : world.getEntities((Entity)player, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                    LivingEntity le;
                    if (!(otherEntity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)otherEntity, (LivingEntity)player)) continue;
                    if (le.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
                        int a = le.getEffect(MobEffects.MOVEMENT_SLOWDOWN).getAmplifier() + 1;
                        le.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, Math.max(a, 3)), (Entity)player);
                    } else {
                        le.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 0), (Entity)player);
                    }
                    float choose = (float)(Math.random() * 1.0);
                    world.playSound(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_ICE_SHOOT_IMPACT_03.get(), le.getSoundSource(), 0.1f, choose);
                    float abilityDamage = HelperMethods.spellScaledDamage("frost", entity, Config.uniqueEffects.icewhisper.spellScaling, Config.uniqueEffects.icewhisper.damage);
                    le.hurt(player.damageSources().indirectMagic(entity, entity), abilityDamage);
                }
                world.playSound(null, (Entity)player, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_ICE_ATTACK_02.get(), player.getSoundSource(), 0.1f, 0.6f);
                double xpos = player.getX() - (double)(radius + 1);
                double ypos = player.getY();
                double zpos = player.getZ() - (double)(radius + 1);
                for (int i = radius * 2; i > 0; --i) {
                    for (int j = radius * 2; j > 0; --j) {
                        float choose = (float)(Math.random() * 1.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.SNOWFLAKE, xpos + (double)i + (double)choose, ypos + 0.4, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.CLOUD, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                        HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.WHITE_ASH, xpos + (double)i + (double)choose, ypos + 2.0, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.SNOWFLAKE, (ParticleOptions)ParticleTypes.SNOWFLAKE, (ParticleOptions)ParticleTypes.WHITE_ASH, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        double radius = Config.uniqueEffects.icewhisper.radius;
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.icewhispersworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.icewhispersworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.icewhispersworditem.tooltip3", (Object[])new Object[]{radius}).setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclickheld").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.icewhispersworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.icewhispersworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.icewhispersworditem.tooltip6", (Object[])new Object[]{radius * 2.0}).setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "frost");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damage;
        @ValidatedInt.Restrict(min=0)
        public int duration;
        @ValidatedInt.Restrict(min=1)
        public int radius;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.ICEWHISPER.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.cooldown = 600;
            this.damage = 1.0f;
            this.duration = 200;
            this.radius = 4;
            this.spellScaling = 0.9f;
        }
    }
}

