/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity.goal;

import java.util.EnumSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.sweenus.simplyswords.entity.SimplySwordsAxolotlEntity;

public class FollowNearestPlayerGoal
extends Goal {
    private final SimplySwordsAxolotlEntity axolotl;
    private Player targetPlayer;
    private final double followSpeed;
    private final double searchRadius;
    private final double stopDistance;

    public FollowNearestPlayerGoal(SimplySwordsAxolotlEntity axolotl, double followSpeed, double searchRadius, double stopDistance) {
        this.axolotl = axolotl;
        this.followSpeed = followSpeed;
        this.searchRadius = searchRadius;
        this.stopDistance = stopDistance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        Player nearestPlayer;
        if (this.axolotl.level() instanceof ServerLevel && (nearestPlayer = this.axolotl.level().getNearestPlayer(this.axolotl.getX(), this.axolotl.getY(), this.axolotl.getZ(), this.searchRadius, false)) != null) {
            this.targetPlayer = nearestPlayer;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.targetPlayer != null && this.targetPlayer.isAlive() && this.axolotl.distanceToSqr((Entity)this.targetPlayer) > this.stopDistance * this.stopDistance;
    }

    public void stop() {
        this.targetPlayer = null;
        this.axolotl.getNavigation().stop();
    }

    public void tick() {
        if (this.targetPlayer != null) {
            this.axolotl.getNavigation().moveTo(this.targetPlayer.getX(), this.targetPlayer.getY(), this.targetPlayer.getZ(), this.followSpeed);
            Vec3 targetPosition = this.targetPlayer.position();
            this.axolotl.getLookControl().setLookAt(targetPosition.x, targetPosition.y, targetPosition.z);
        }
    }
}

