/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.entity.ThrownSpearEntity;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class WraithfangEntity
extends ThrownSpearEntity {
    public int slownessDuration;

    public WraithfangEntity(EntityType<? extends WraithfangEntity> entityType, Level world) {
        super(entityType, world);
    }

    public WraithfangEntity(Level world, LivingEntity owner, ItemStack stack) {
        super(world, owner, stack);
        this.stack = stack;
    }

    @Override
    public void tick() {
        Level level;
        this.returnToPlayer = true;
        Entity owner = this.getOwner();
        if (owner != null && owner.distanceTo((Entity)this) > 1.0f && owner.distanceTo((Entity)this) < 500.0f && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.tickCount < 100) {
                owner.setDeltaMovement((this.getX() - owner.getX()) / 8.0, (this.getY() - owner.getY()) / 8.0, (this.getZ() - owner.getZ()) / 8.0);
                owner.hurtMarked = true;
                HelperMethods.spawnWaistHeightParticles(serverWorld, (ParticleOptions)ParticleTypes.OMINOUS_SPAWNING, (Entity)this, owner, (int)this.distanceTo(owner));
                if (owner instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)owner;
                    livingEntity.addEffect(new MobEffectInstance(EffectRegistry.getReference(EffectRegistry.RESILIENCE), 20, 4, false, false, true));
                }
            }
        }
        super.tick();
    }

    @Override
    protected boolean tryPickup(Player player) {
        if (this.isNoPhysics() && this.ownedBy((Entity)player)) {
            player.level().playSound((Entity)this, this.blockPosition(), (SoundEvent)SoundRegistry.ELEMENTAL_BOW_WIND_SHOOT_IMPACT_02.get(), this.getSoundSource(), 0.1f, 1.2f);
            player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, Config.uniqueEffects.wraithfang.duration, Config.uniqueEffects.wraithfang.hasteAmplifier, false, false, true));
            int cooldown = 10;
            player.getCooldowns().addCooldown(this.getPickupItem().getItem(), cooldown);
            if (this.offhandThrow && player.getOffhandItem().isEmpty()) {
                player.setItemInHand(InteractionHand.OFF_HAND, this.getPickupItem());
                return true;
            }
            return player.getInventory().add(this.getPickupItem());
        }
        return super.tryPickup(player);
    }

    @Override
    public ItemStack getPickupItemStackOrigin() {
        return this.stack;
    }

    @Override
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ItemsRegistry.WRAITHFANG.get());
    }

    @Override
    protected byte getLoyalty() {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            return 3;
        }
        return 0;
    }
}

