/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.sweenus.simplyswords.registry.EntityRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import org.jetbrains.annotations.Nullable;

public class ThrownSpearEntity
extends AbstractArrow {
    private boolean dealtDamage;
    private static final EntityDataAccessor<Byte> LOYALTY;
    private static final EntityDataAccessor<Boolean> ENCHANTED;
    private static final EntityDataAccessor<ItemStack> ITEM_STACK;
    public ItemStack stack;
    public int returnTimer;
    public AbstractArrow.Pickup pickupType;
    public boolean hasYaw = false;
    private Float initialYaw = null;
    public float keepYaw;
    public float keepPitch = 0.0f;
    public boolean offhandThrow = false;
    public float primaryBaseDamage;
    public float primaryReturnDamage;
    public double primaryReturnDamageRadius;
    public boolean returnToPlayer = true;
    public static int offset;
    public int hasLoyalty;
    public float weightValue = 0.05f;

    public ThrownSpearEntity(EntityType<? extends ThrownSpearEntity> entityType, Level world) {
        super(entityType, world);
    }

    public ThrownSpearEntity(Level world, LivingEntity owner, ItemStack stack) {
        super((EntityType)EntityRegistry.SPEAR.get(), owner, world, stack, (ItemStack)null);
        this.entityData.set(LOYALTY, (Object)this.getLoyalty());
        this.entityData.set(ENCHANTED, (Object)stack.isEnchanted());
        this.entityData.set(ITEM_STACK, (Object)stack);
        this.stack = stack;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LOYALTY, (Object)0);
        builder.define(ENCHANTED, (Object)false);
        builder.define(ITEM_STACK, (Object)ItemStack.EMPTY);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)ItemsRegistry.LIVYATAN.get());
    }

    protected boolean tryPickup(Player player) {
        if (this.isNoPhysics() && this.ownedBy((Entity)player)) {
            int cooldown = 1;
            if (this.offhandThrow) {
                cooldown = 4;
            }
            player.getCooldowns().addCooldown(this.getPickupItem().getItem(), cooldown);
            if (this.offhandThrow && player.getOffhandItem().isEmpty()) {
                player.setItemInHand(InteractionHand.OFF_HAND, this.getPickupItem());
                return true;
            }
            return player.getInventory().add(this.getPickupItem());
        }
        return super.tryPickup(player);
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
            this.setDeltaMovement(this.getDeltaMovement().x, 0.07, this.getDeltaMovement().z);
        }
        if (this.keepPitch == 0.0f && !this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y - (double)this.weightValue, this.getDeltaMovement().z);
        } else if (this.keepPitch > 0.0f && this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
        }
        Entity entity = this.getOwner();
        int i = this.hasLoyalty;
        if (i > 0 && (this.dealtDamage || this.isNoPhysics()) && entity != null && this.returnToPlayer) {
            if (!this.isOwnerAlive()) {
                if (!this.level().isClientSide && this.pickupType == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3 vec3d = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + vec3d.y * 0.015 * (double)i, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double d = 0.05 * (double)i;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3d.normalize().scale(d)));
                if (this.returnTimer == 0) {
                    this.playSound(this.getReturnSound(), 0.2f, 1.2f);
                }
                this.damageOnReturn(this.primaryReturnDamageRadius, this.primaryReturnDamage);
                ++this.returnTimer;
            }
        }
        super.tick();
        Vec3 velocity = this.getDeltaMovement();
        if (this.initialYaw == null) {
            this.initialYaw = Float.valueOf((float)(-Math.toDegrees(Math.atan2(velocity.x, velocity.z))));
        }
        float calculatedPitch = (float)(-Math.toDegrees(Math.atan2(velocity.y, Math.sqrt(velocity.x * velocity.x + velocity.z * velocity.z))));
        float fixedYaw = this.initialYaw.floatValue();
        if (this.inGround) {
            this.setRot(fixedYaw + 90.0f, this.keepPitch);
        } else {
            this.setRot(fixedYaw + 90.0f, calculatedPitch + 45.0f);
        }
        this.doOnTick(entity);
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.setPos(x, y, z);
        Vec3 velocity = this.getDeltaMovement();
        if (this.initialYaw == null) {
            this.initialYaw = Float.valueOf((float)(-Math.toDegrees(Math.atan2(velocity.x, velocity.z))));
        }
        float calculatedPitch = (float)(-Math.toDegrees(Math.atan2(velocity.y, Math.sqrt(velocity.x * velocity.x + velocity.z * velocity.z))));
        float fixedYaw = this.initialYaw.floatValue();
        if (this.inGround) {
            this.setRot(fixedYaw + 90.0f, this.keepPitch);
        } else {
            this.setRot(fixedYaw + 90.0f, calculatedPitch + 45.0f);
        }
    }

    private boolean isOwnerAlive() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !(entity instanceof ServerPlayer) || !entity.isSpectator();
        }
        return false;
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        this.keepPitch = this.getXRot();
        super.onHitBlock(blockHitResult);
    }

    protected void doOnTick(Entity owner) {
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.getEntity();
        this.keepPitch = this.getXRot();
        float baseDamage = this.primaryBaseDamage;
        Entity entity2 = this.getOwner();
        DamageSource damageSource = this.damageSources().trident((Entity)this, (Entity)(entity2 == null ? this : entity2));
        float agedDamage = this.doExtraDamage(entity, baseDamage, damageSource);
        Level world = this.level();
        this.dealtDamage = true;
        if (HelperMethods.damageThroughIframes(entity, damageSource, agedDamage)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverWorld, (Entity)entity, (DamageSource)damageSource, (ItemStack)this.stack);
            }
            if (entity instanceof LivingEntity) {
                Entity entity3;
                LivingEntity livingEntity = (LivingEntity)entity;
                this.doKnockback(livingEntity, damageSource);
                this.doPostHurtEffects(livingEntity);
                if (this.stack != null && !this.stack.isEmpty() && (entity3 = this.getOwner()) instanceof LivingEntity) {
                    LivingEntity livingOwner = (LivingEntity)entity3;
                    Item weaponItem = this.stack.getItem();
                    if (weaponItem instanceof SwordItem) {
                        ((SwordItem)weaponItem).hurtEnemy(this.stack, livingEntity, livingOwner);
                    }
                }
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(this.getEntityHitSound(), 1.0f, 1.0f);
    }

    protected float doExtraDamage(Entity entity, float baseDamage, DamageSource damageSource) {
        float agedDamage = baseDamage + (float)this.tickCount / 2.0f;
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            agedDamage = EnchantmentHelper.modifyDamage((ServerLevel)serverWorld, (ItemStack)this.stack, (Entity)entity, (DamageSource)damageSource, (float)agedDamage);
            this.doEffects(serverWorld, baseDamage, entity);
        }
        return agedDamage;
    }

    protected void doEffects(ServerLevel serverWorld, float baseDamage, Entity entity) {
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 currentPosition, Vec3 nextPosition) {
        return this.dealtDamage ? null : super.findHitEntity(currentPosition, nextPosition);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.dealtDamage = nbt.getBoolean("DealtDamage");
        this.entityData.set(LOYALTY, (Object)this.getLoyalty());
        if (nbt.contains("Stack")) {
            this.entityData.set(ITEM_STACK, (Object)this.stack);
            this.stack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)nbt.getCompound("item")).orElse(this.getDefaultPickupItem());
        } else {
            this.stack = ItemStack.EMPTY;
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("DealtDamage", this.dealtDamage);
        if (!this.stack.isEmpty()) {
            nbt.put("item", this.stack.save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    protected byte getLoyalty() {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            return (byte)this.hasLoyalty;
        }
        return 0;
    }

    public ItemStack getPickupItemStackOrigin() {
        return (ItemStack)this.entityData.get(ITEM_STACK);
    }

    public ItemStack getWeaponItem() {
        return this.getPickupItemStackOrigin();
    }

    protected void damageOnReturn(double radius, float damage) {
    }

    public boolean isEnchanted() {
        return (Boolean)this.entityData.get(ENCHANTED);
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    protected SoundEvent getReturnSound() {
        return SoundEvents.TRIDENT_RETURN;
    }

    protected SoundEvent getEntityHitSound() {
        return SoundEvents.TRIDENT_HIT;
    }

    public void tickDespawn() {
        byte i = (Byte)this.entityData.get(LOYALTY);
        if (this.pickupType != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.tickDespawn();
        }
    }

    static {
        offset = 210;
        LOYALTY = SynchedEntityData.defineId(ThrownSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
        ENCHANTED = SynchedEntityData.defineId(ThrownSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        ITEM_STACK = SynchedEntityData.defineId(ThrownSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    }
}

