/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.util.HelperMethods;

public class WildfireEffect
extends MobEffect {
    public WildfireEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity pLivingEntity, int pAmplifier) {
        LivingEntity pPlayer;
        if (!pLivingEntity.level().isClientSide() && (pPlayer = pLivingEntity.getLastHurtByMob()) != null && pPlayer instanceof Player) {
            ServerLevel world = (ServerLevel)pLivingEntity.level();
            double hradius = Config.gemPowers.wildfire.radius;
            double vradius = Config.gemPowers.wildfire.radius / 2.0;
            double x = pLivingEntity.getX();
            double y = pLivingEntity.getY();
            double z = pLivingEntity.getZ();
            int pduration = Config.gemPowers.wildfire.duration / 20;
            AABB box = new AABB(x + hradius, y + vradius, z + hradius, x - hradius, y - vradius, z - hradius);
            for (Entity e : world.getEntities((EntityTypeTest)pLivingEntity.getType(), box, EntitySelector.ENTITY_STILL_ALIVE)) {
                if (!(e instanceof LivingEntity) || !HelperMethods.checkFriendlyFire((LivingEntity)e, (LivingEntity)((Player)pPlayer))) continue;
                e.igniteForSeconds((float)pduration);
            }
        }
        super.applyEffectTick(pLivingEntity, pAmplifier);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }
}

