/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.effect.OrbitingEffect;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class FlameSeedEffect
extends OrbitingEffect {
    public LivingEntity sourceEntity;
    public int additionalData;

    public FlameSeedEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType((ParticleOptions)ParticleTypes.ASH);
    }

    public void setSourcePlayer(LivingEntity livingEntity) {
        this.sourceEntity = livingEntity;
    }

    public void setAdditionalData(int data) {
        this.additionalData = data;
    }

    @Override
    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        int duration = 0;
        if (!livingEntity.level().isClientSide()) {
            ServerLevel serverWorld = (ServerLevel)livingEntity.level();
            float abilityDamage = Config.uniqueEffects.flamewind.damage;
            float volume = 0.3f;
            float pitch = 1.3f;
            int frequency = 20;
            SoundEvent soundEvent = SoundEvents.GENERIC_BURN;
            MobEffectInstance mobEffectInstance = livingEntity.getEffect(EffectRegistry.getReference(EffectRegistry.FLAMESEED));
            if (mobEffectInstance instanceof SimplySwordsStatusEffectInstance) {
                SimplySwordsStatusEffectInstance statusEffect = (SimplySwordsStatusEffectInstance)mobEffectInstance;
                this.sourceEntity = statusEffect.getSourceEntity();
                this.additionalData = statusEffect.getAdditionalData();
                duration = statusEffect.getDuration();
            }
            if (livingEntity.tickCount % frequency == 0 && this.additionalData != 0) {
                Object object;
                DamageSource damageSource = livingEntity.damageSources().magic();
                livingEntity.invulnerableTime = 0;
                if (duration < 20 && this.sourceEntity != null) {
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position(), (ParticleOptions)ParticleTypes.LAVA, 1.0, 8);
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position(), (ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, 2.0, 6);
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position(), (ParticleOptions)ParticleTypes.POOF, 1.0, 10);
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position(), (ParticleOptions)ParticleTypes.EXPLOSION, 0.5, 2);
                    HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position(), (ParticleOptions)ParticleTypes.WARPED_SPORE, 1.0, 10);
                    abilityDamage = Config.uniqueEffects.flamewind.detonationDamage;
                    volume = 0.6f;
                    pitch = 1.0f;
                    soundEvent = (SoundEvent)SoundRegistry.SPELL_FIRE.get();
                    if (livingEntity.distanceTo((Entity)this.sourceEntity) < 30.0f) {
                        int maxHaste = Config.uniqueEffects.flamewind.maxHaste;
                        HelperMethods.incrementStatusEffect(this.sourceEntity, (Holder<MobEffect>)MobEffects.DIG_SPEED, 120, 1, maxHaste);
                    }
                    AABB box = HelperMethods.createBox((Entity)livingEntity, 3.0);
                    object = serverWorld.getEntities((Entity)livingEntity, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE).iterator();
                    while (object.hasNext()) {
                        LivingEntity le;
                        Entity entity = (Entity)object.next();
                        if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, this.sourceEntity)) continue;
                        le.hurt(damageSource, abilityDamage);
                        if (le.hasEffect(EffectRegistry.getReference(EffectRegistry.FLAMESEED)) || this.additionalData <= 0) continue;
                        --this.additionalData;
                        SimplySwordsStatusEffectInstance flamSeedEffect = new SimplySwordsStatusEffectInstance(EffectRegistry.getReference(EffectRegistry.FLAMESEED), 101, 0, false, false, true);
                        flamSeedEffect.setSourceEntity(this.sourceEntity);
                        flamSeedEffect.setAdditionalData(this.additionalData);
                        le.addEffect((MobEffectInstance)flamSeedEffect);
                        le.setDeltaMovement(le.getX() - livingEntity.getX(), 0.5, le.getZ() - livingEntity.getZ());
                    }
                }
                if (this.sourceEntity != null) {
                    damageSource = livingEntity.damageSources().indirectMagic((Entity)livingEntity, (Entity)this.sourceEntity);
                    float spellScalingModifier = Config.uniqueEffects.flamewind.spellScaling;
                    if (HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)this.sourceEntity, "fire") > abilityDamage) {
                        abilityDamage = HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)this.sourceEntity, "fire");
                    }
                }
                if (livingEntity instanceof Player && this.sourceEntity != null && (object = this.sourceEntity) instanceof Player) {
                    Player playerSourceEntity = (Player)object;
                    damageSource = livingEntity.damageSources().playerAttack(playerSourceEntity);
                }
                livingEntity.hurt(damageSource, (float)this.additionalData + (float)amplifier / 4.0f + abilityDamage);
                serverWorld.playSound(null, livingEntity.blockPosition(), soundEvent, livingEntity.getSoundSource(), volume, pitch);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position(), (ParticleOptions)ParticleTypes.LAVA, 1.0, 4);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position(), (ParticleOptions)ParticleTypes.ASH, 1.0, 6);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.position(), (ParticleOptions)ParticleTypes.SMOKE, 1.0, 6);
            }
        }
        super.applyEffectTick(livingEntity, amplifier);
        return true;
    }

    @Override
    public void removeAttributeModifiers(AttributeMap attributes) {
        super.removeAttributeModifiers(attributes);
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return super.shouldApplyEffectTickThisTick(pDuration, pAmplifier);
    }
}

