/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords;

import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.io.IOException;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.AxolotlRenderer;
import net.minecraft.client.renderer.entity.BeeRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.sweenus.simplyswords.SimplySwordsExpectPlatform;
import net.sweenus.simplyswords.client.renderer.BattleStandardDarkRenderer;
import net.sweenus.simplyswords.client.renderer.BattleStandardRenderer;
import net.sweenus.simplyswords.client.renderer.ThrownSpearEntityRenderer;
import net.sweenus.simplyswords.client.renderer.ThrownSwordEntityRenderer;
import net.sweenus.simplyswords.client.renderer.model.BattleStandardDarkModel;
import net.sweenus.simplyswords.client.renderer.model.BattleStandardModel;
import net.sweenus.simplyswords.compat.MythicMetalsCompat;
import net.sweenus.simplyswords.compat.eldritch_end.EldritchEndCompatRegistry;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.entity.BattleStandardDarkEntity;
import net.sweenus.simplyswords.entity.BattleStandardEntity;
import net.sweenus.simplyswords.entity.SimplySwordsAxolotlEntity;
import net.sweenus.simplyswords.entity.SimplySwordsBeeEntity;
import net.sweenus.simplyswords.registry.ComponentTypeRegistry;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.EntityRegistry;
import net.sweenus.simplyswords.registry.GemPowerRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.ParticlesRegistry;
import net.sweenus.simplyswords.registry.RecipeTypeRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.registry.TransformationRegistry;
import net.sweenus.simplyswords.util.FileCopier;
import net.sweenus.simplyswords.util.ModLootTableModifiers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimplySwords {
    public static final String MOD_ID = "simplyswords";
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((String)"simplyswords", (ResourceKey)Registries.CREATIVE_MODE_TAB);
    public static final RegistrySupplier<CreativeModeTab> SIMPLYSWORDS = TABS.register("simplyswords", () -> CreativeTabRegistry.create((Component)Component.translatable((String)"itemGroup.simplyswords.simplyswords"), () -> new ItemStack((ItemLike)ItemsRegistry.RUNIC_TABLET.get())));
    public static final Logger LOGGER = LogManager.getLogger((String)"simplyswords");
    public static String minimumEldritchEndVersion = "0.2.40";
    public static String minimumSpellPowerVersion = "0.10.0+1.20.1";
    public static String minimumSpellbookVersion = "1.21-3.8.0";
    public static String minimumMythicMetalsVersion = "0.24.0+1.21";

    public static void init() {
        Config.init();
        TABS.register();
        ItemsRegistry.ITEM.register();
        SoundRegistry.SOUND.register();
        EffectRegistry.EFFECT.register();
        RecipeTypeRegistry.RECIPES.register();
        EntityRegistry.ENTITIES.register();
        ComponentTypeRegistry.COMPONENT_TYPES.register();
        GemPowerRegistry.register();
        ParticlesRegistry.PARTICLES.register();
        TransformationRegistry.register();
        EntityAttributeRegistry.register(EntityRegistry.BATTLESTANDARD, BattleStandardEntity::createBattleStandardAttributes);
        EntityAttributeRegistry.register(EntityRegistry.BATTLESTANDARDDARK, BattleStandardDarkEntity::createBattleStandardDarkAttributes);
        EntityAttributeRegistry.register(EntityRegistry.SIMPLYBEEENTITY, SimplySwordsBeeEntity::createSimplyBeeAttributes);
        EntityAttributeRegistry.register(EntityRegistry.SIMPLYAXOLOTLENTITY, SimplySwordsAxolotlEntity::createSimplyAxolotlAttributes);
        ModLootTableModifiers.init();
        if (SimplySwords.passVersionCheck("eldritch_end", minimumEldritchEndVersion)) {
            EldritchEndCompatRegistry.EFFECT.register();
        }
        if (SimplySwords.passVersionCheck("mythicmetals", minimumMythicMetalsVersion)) {
            LOGGER.info("Registering Mythic Metals items");
            MythicMetalsCompat.init();
        }
        try {
            FileCopier.copyFileToConfigDirectory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println(SimplySwordsExpectPlatform.getConfigDirectory().toAbsolutePath().normalize().toString());
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Client::initializeClient);
    }

    public static boolean passVersionCheck(String modId, String requiredVersion) {
        return Platform.isModLoaded((String)modId) && Platform.getMod((String)modId).getVersion().compareTo(requiredVersion) >= 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        public static final ModelLayerLocation BATTLESTANDARD_MODEL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"battlestandard", (String)"cube"), "main");
        public static final ModelLayerLocation BATTLESTANDARD_DARK_MODEL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"battlestandarddark", (String)"cube"), "main");

        @OnlyIn(value=Dist.CLIENT)
        public static void initializeClient() {
            EntityRendererRegistry.register(EntityRegistry.BATTLESTANDARD, BattleStandardRenderer::new);
            EntityModelLayerRegistry.register((ModelLayerLocation)BATTLESTANDARD_MODEL, BattleStandardModel::getTexturedModelData);
            EntityRendererRegistry.register(EntityRegistry.BATTLESTANDARDDARK, BattleStandardDarkRenderer::new);
            EntityModelLayerRegistry.register((ModelLayerLocation)BATTLESTANDARD_DARK_MODEL, BattleStandardDarkModel::getTexturedModelData);
            EntityRendererRegistry.register(EntityRegistry.SIMPLYBEEENTITY, BeeRenderer::new);
            EntityRendererRegistry.register(EntityRegistry.SIMPLYAXOLOTLENTITY, AxolotlRenderer::new);
            EntityRendererRegistry.register(EntityRegistry.THROWNSWORDENTITY, ThrownSwordEntityRenderer::new);
            EntityRendererRegistry.register(EntityRegistry.FROSTFALLENTITY, ThrownSwordEntityRenderer::new);
            EntityRendererRegistry.register(EntityRegistry.LIVYATANENTITY, ThrownSwordEntityRenderer::new);
            EntityRendererRegistry.register(EntityRegistry.SPEAR, ThrownSpearEntityRenderer::new);
            EntityRendererRegistry.register(EntityRegistry.THROWNRUNICENTITY, ThrownSwordEntityRenderer::new);
        }
    }
}

