/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.glue;

import com.simibubi.create.AllPackets;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.glue.SuperGlueSelectionHelper;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record SuperGlueSelectionPacket(BlockPos from, BlockPos to) implements ServerboundPacketPayload
{
    public static final StreamCodec<ByteBuf, SuperGlueSelectionPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SuperGlueSelectionPacket::from, (StreamCodec)BlockPos.STREAM_CODEC, SuperGlueSelectionPacket::to, SuperGlueSelectionPacket::new);

    public void handle(ServerPlayer player) {
        double range = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) + 2.0;
        if (player.distanceToSqr(Vec3.atCenterOf((Vec3i)this.to)) > range * range) {
            return;
        }
        if (!this.to.closerThan((Vec3i)this.from, 25.0)) {
            return;
        }
        Set<BlockPos> group = SuperGlueSelectionHelper.searchGlueGroup(player.level(), this.from, this.to, false);
        if (group == null) {
            return;
        }
        if (!group.contains(this.to)) {
            return;
        }
        if (!SuperGlueSelectionHelper.collectGlueFromInventory((Player)player, 1, true)) {
            return;
        }
        AABB bb = SuperGlueEntity.span(this.from, this.to);
        SuperGlueSelectionHelper.collectGlueFromInventory((Player)player, 1, false);
        SuperGlueEntity entity = new SuperGlueEntity(player.level(), bb);
        player.level().addFreshEntity((Entity)entity);
        entity.spawnParticles();
        AllAdvancements.SUPER_GLUE.awardTo((Player)player);
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return AllPackets.GLUE_IN_AREA;
    }
}

