/*
 * Decompiled with CFR 0.152.
 */
package dev.norbiros.emojitype.mixin;

import dev.norbiros.emojitype.EmojiType;
import dev.norbiros.emojitype.emoji.EmojiCode;
import java.util.Objects;
import net.minecraft.client.gui.components.EditBox;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EditBox.class})
public abstract class TextFieldWidgetMixin {
    @Shadow
    private String value;
    @Shadow
    private int cursorPos;
    @Shadow
    private int highlightPos;

    @Shadow
    public abstract String getValue();

    @Shadow
    protected abstract void onValueChange(String var1);

    @Inject(method={"charTyped(CI)Z"}, at={@At(value="RETURN")})
    private void inject(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        String result = this.getValue();
        for (EmojiCode emojiCode : EmojiType.emojiCodes) {
            result = result.replace(emojiCode.getCode(), emojiCode.getEmoji());
        }
        if (!Objects.equals(this.value, result)) {
            int newCursorPosition;
            int lengthDifference = this.value.length() - result.length();
            this.highlightPos = this.cursorPos = (newCursorPosition = Math.max(Math.min(this.highlightPos - lengthDifference + 1, result.length()), 0));
        }
        this.value = result;
        this.onValueChange(result);
    }
}

