/*
 * Decompiled with CFR 0.152.
 */
package dev.norbiros.emojitype.mixin;

import dev.norbiros.emojitype.EmojiType;
import dev.norbiros.emojitype.emoji.EmojiCode;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.font.TextFieldHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TextFieldHelper.class})
public abstract class SelectionManagerMixin {
    @Shadow
    private int cursorPos;
    @Shadow
    private int selectionPos;
    @Shadow
    @Final
    private Supplier<String> getMessageFn;
    @Shadow
    @Final
    private Consumer<String> setMessageFn;

    @Inject(method={"insertText(Ljava/lang/String;Ljava/lang/String;)V"}, at={@At(value="TAIL")})
    private void inject(String _unused, String insertion, CallbackInfo ci) {
        String result = this.getMessageFn.get();
        for (EmojiCode emojiCode : EmojiType.emojiCodes) {
            result = result.replace(emojiCode.getCode(), emojiCode.getEmoji());
        }
        if (!Objects.equals(this.getMessageFn.get(), result)) {
            int newCursorPosition;
            int lengthDifference = this.getMessageFn.get().length() - result.length();
            this.selectionPos = this.cursorPos = (newCursorPosition = Math.max(Math.min(this.selectionPos - lengthDifference + 1, result.length()), 0));
        }
        this.setMessageFn.accept(result);
    }
}

