/*
 * Decompiled with CFR 0.152.
 */
package dev.norbiros.emojitype.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import dev.norbiros.emojitype.ConfigDirPlatform;
import dev.norbiros.emojitype.EmojiType;
import dev.norbiros.emojitype.emoji.EmojiCode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class ConfigUtil {
    public static Path CONFIG_PATH = ConfigDirPlatform.getConfigDirectory().resolve("emojitype.json");
    public static List<String> emojiCodeStrings = new ArrayList<String>();

    public static void serialise() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson(emojiCodeStrings));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        EmojiType.update(emojiCodeStrings);
    }

    public static void deserialise() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);
                emojiCodeStrings = (List)new Gson().fromJson((Reader)reader, new TypeToken<ArrayList<String>>(){}.getType());
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            EmojiType.update(emojiCodeStrings);
        } else {
            emojiCodeStrings.clear();
            for (EmojiCode ec : EmojiType.DEFAULT_EMOJI_CODES) {
                emojiCodeStrings.add(ec.toString());
            }
            ConfigUtil.serialise();
        }
    }
}

