/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

public final class EnumCodec<T extends Enum<T>>
implements Codec<T> {
    private final Codec<T> codec;

    private EnumCodec(Codec<T> codec) {
        this.codec = codec;
    }

    public static <T extends Enum<T>> EnumCodec<T> of(Class<T> clazz) {
        return new EnumCodec<T>(EnumCodec.intOrConstCodec(clazz));
    }

    public static <T extends Enum<T>> EnumCodec<T> ofRepresentable(Class<T> clazz, Function<String, @Nullable T> getter) {
        return new EnumCodec<T>(EnumCodec.intOrConstOrRepresentableCodec(clazz, getter));
    }

    public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
        return this.codec.decode(ops, input);
    }

    public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
        return this.codec.encode(input, ops, prefix);
    }

    private static <T extends Enum<T>> Codec<T> intOrConstCodec(Class<T> enumClass) {
        return CodecExtras.eitherLeft(Codec.either(EnumCodec.constCodec(enumClass), EnumCodec.intCodec(enumClass)));
    }

    private static <T extends Enum<T>> Codec<T> intOrConstOrRepresentableCodec(Class<T> enumClass, Function<String, T> getter) {
        return CodecExtras.eitherLeft(Codec.either(EnumCodec.representableCodec(getter), EnumCodec.intOrConstCodec(enumClass)));
    }

    private static <T extends Enum<T>> Codec<T> intCodec(Class<T> enumClass) {
        return Codec.INT.flatXmap(ordinal -> {
            Enum[] values = (Enum[])enumClass.getEnumConstants();
            if (ordinal >= 0 && ordinal < values.length) {
                return DataResult.success((Object)values[ordinal]);
            }
            return DataResult.error(() -> "Unknown enum ordinal: " + ordinal);
        }, value -> DataResult.success((Object)value.ordinal()));
    }

    private static <T extends Enum<T>> Codec<T> constCodec(Class<T> enumClass) {
        return Codec.STRING.flatXmap(id -> {
            try {
                return DataResult.success(Enum.valueOf(enumClass, id.toUpperCase(Locale.ROOT)));
            }
            catch (Exception e) {
                return DataResult.error(() -> "Unknown type: " + id);
            }
        }, value -> DataResult.success((Object)value.name()));
    }

    private static <T extends Enum<T>> Codec<T> representableCodec(Function<String, @Nullable T> getter) {
        return Codec.STRING.flatXmap(id -> {
            Enum value = (Enum)getter.apply((String)id);
            return value != null ? DataResult.success((Object)value) : DataResult.error(() -> "Unknown type: " + id);
        }, value -> DataResult.success((Object)((StringRepresentable)value).getSerializedName()));
    }
}

