/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.block.redstone_wire;

import net.caffeinemc.mods.lithium.common.util.DirectionConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RedStoneWireBlock.class})
public class RedStoneWireBlockMixin
extends Block {
    private static final int MIN = 0;
    private static final int MAX = 15;
    private static final int MAX_WIRE = 14;

    public RedStoneWireBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Inject(method={"calculateTargetStrength(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I"}, cancellable=true, at={@At(value="HEAD")})
    private void getReceivedPowerFaster(Level world, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)this.getReceivedPower(world, pos));
    }

    private int getReceivedPower(Level world, BlockPos pos) {
        LevelChunk chunk = world.getChunkAt(pos);
        int power = 0;
        for (Direction dir : DirectionConstants.VERTICAL) {
            BlockPos side = pos.relative(dir);
            BlockState neighbor = chunk.getBlockState(side);
            if (neighbor.isAir() || neighbor.is((Block)this) || (power = Math.max(power, this.getPowerFromVertical(world, side, neighbor, dir))) < 15) continue;
            return 15;
        }
        BlockPos up = pos.above();
        boolean checkWiresAbove = !chunk.getBlockState(up).isRedstoneConductor((BlockGetter)world, up);
        for (Direction dir : DirectionConstants.HORIZONTAL) {
            if ((power = Math.max(power, this.getPowerFromSide(world, pos.relative(dir), dir, checkWiresAbove))) < 15) continue;
            return 15;
        }
        return power;
    }

    private int getPowerFromVertical(Level world, BlockPos pos, BlockState state, Direction toDir) {
        int power = state.getSignal((BlockGetter)world, pos, toDir);
        if (power >= 15) {
            return 15;
        }
        if (state.isRedstoneConductor((BlockGetter)world, pos)) {
            return Math.max(power, this.getStrongPowerTo(world, pos, toDir.getOpposite()));
        }
        return power;
    }

    private int getPowerFromSide(Level world, BlockPos pos, Direction toDir, boolean checkWiresAbove) {
        BlockPos down;
        BlockState belowState;
        LevelChunk chunk = world.getChunkAt(pos);
        BlockState state = chunk.getBlockState(pos);
        if (state.is((Block)this)) {
            return (Integer)state.getValue((Property)BlockStateProperties.POWER) - 1;
        }
        int power = state.getSignal((BlockGetter)world, pos, toDir);
        if (power >= 15) {
            return 15;
        }
        if (state.isRedstoneConductor((BlockGetter)world, pos)) {
            BlockPos up;
            BlockState aboveState;
            if ((power = Math.max(power, this.getStrongPowerTo(world, pos, toDir.getOpposite()))) >= 15) {
                return 15;
            }
            if (checkWiresAbove && power < 14 && (aboveState = chunk.getBlockState(up = pos.above())).is((Block)this)) {
                power = Math.max(power, (Integer)aboveState.getValue((Property)BlockStateProperties.POWER) - 1);
            }
        } else if (power < 14 && (belowState = chunk.getBlockState(down = pos.below())).is((Block)this)) {
            power = Math.max(power, (Integer)belowState.getValue((Property)BlockStateProperties.POWER) - 1);
        }
        return power;
    }

    private int getStrongPowerTo(Level world, BlockPos pos, Direction ignore) {
        int power = 0;
        for (Direction dir : DirectionConstants.ALL) {
            BlockPos side;
            BlockState neighbor;
            if (dir == ignore || (neighbor = world.getBlockState(side = pos.relative(dir))).isAir() || neighbor.is((Block)this) || (power = Math.max(power, neighbor.getDirectSignal((BlockGetter)world, side, dir))) < 15) continue;
            return 15;
        }
        return power;
    }
}

