/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.network;

import net.mehvahdjukaar.amendments.Amendments;
import net.mehvahdjukaar.amendments.common.ISwingingTile;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record ClientBoundEntityHitSwayingBlockMessage(BlockPos pos, int entity) implements Message
{
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ClientBoundEntityHitSwayingBlockMessage> TYPE = Message.makeType((ResourceLocation)Amendments.res("client_bound_sync_swaying_tile"), ClientBoundEntityHitSwayingBlockMessage::new);

    public ClientBoundEntityHitSwayingBlockMessage(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos(), buffer.readVarInt());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeVarInt(this.entity);
    }

    public void handle(Message.Context context) {
        this.doOnClient();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void doOnClient() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            Entity e = level.getEntity(this.entity);
            BlockEntity blockEntity = level.getBlockEntity(this.pos);
            if (blockEntity instanceof ISwingingTile) {
                ISwingingTile tile = (ISwingingTile)blockEntity;
                if (e != null) {
                    tile.amendments$getAnimation().hitByEntity(e, level.getBlockState(this.pos), this.pos);
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE.type();
    }
}

