/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.List;
import net.mehvahdjukaar.amendments.common.tile.CandleSkullBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCandleSkullBlock
extends AbstractCandleBlock
implements EntityBlock,
ILightable,
IWashable {
    protected static final Int2ObjectMap<List<Vec3>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.make(() -> {
        Int2ObjectArrayMap map = new Int2ObjectArrayMap();
        map.defaultReturnValue(List.of());
        map.put(1, List.of(new Vec3(0.5, 1.0, 0.5)));
        map.put(2, List.of(new Vec3(0.375, 0.94, 0.5), new Vec3(0.625, 1.0, 0.44)));
        map.put(3, List.of(new Vec3(0.5, 0.813, 0.625), new Vec3(0.375, 0.94, 0.5), new Vec3(0.56, 1.0, 0.44)));
        map.put(4, List.of(new Vec3(0.44, 0.813, 0.56), new Vec3(0.625, 0.94, 0.56), new Vec3(0.375, 0.94, 0.375), new Vec3(0.56, 1.0, 0.375)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)map);
    });
    protected static final VoxelShape BASE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    protected static final VoxelShape ONE_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0));
    protected static final VoxelShape TWO_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)5.0, (double)8.0, (double)6.0, (double)11.0, (double)14.0, (double)9.0));
    protected static final VoxelShape THREE_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)5.0, (double)8.0, (double)6.0, (double)10.0, (double)14.0, (double)11.0));
    protected static final VoxelShape FOUR_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)14.0, (double)10.0));
    public static final IntegerProperty CANDLES = BlockStateProperties.CANDLES;
    public static final BooleanProperty LIT = AbstractCandleBlock.LIT;

    protected AbstractCandleSkullBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(CandleBlock.LIGHT_EMISSION));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)CANDLES, (Comparable)Integer.valueOf(1)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{CANDLES, LIT});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new CandleSkullBlockTile(pPos, pState);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        CandleSkullBlockTile tile;
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof CandleSkullBlockTile && (tile = (CandleSkullBlockTile)((Object)object)).getCandle().getBlock() instanceof CandleBlock) {
            List loot = ((BlockState)tile.getCandle().setValue((Property)CANDLES, (Comparable)((Integer)state.getValue((Property)CANDLES)))).getDrops(builder);
            BlockEntity skullTile = tile.getSkullTile();
            if (skullTile != null) {
                BlockState skull = skullTile.getBlockState();
                builder = builder.withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)skullTile);
                loot.addAll(skull.getDrops(builder));
            }
            return loot;
        }
        return super.getDrops(state, builder);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CandleSkullBlockTile) {
            CandleSkullBlockTile tile = (CandleSkullBlockTile)blockEntity;
            return tile.getSkullItem();
        }
        return super.getCloneItemStack(level, pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult hitResult, LevelReader world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CandleSkullBlockTile) {
            CandleSkullBlockTile tile = (CandleSkullBlockTile)blockEntity;
            double y = hitResult.getLocation().y;
            boolean up = y % (double)((int)y) > 0.5;
            return up ? tile.getCandle().getBlock().getCloneItemStack(world, pos, state) : tile.getSkullItem();
        }
        return super.getCloneItemStack(world, pos, state);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Integer)pState.getValue((Property)CANDLES)) {
            case 2 -> TWO_AABB;
            case 3 -> THREE_AABB;
            case 4 -> FOUR_AABB;
            default -> ONE_AABB;
        };
    }

    protected Iterable<Vec3> getParticleOffsets(BlockState pState) {
        return (Iterable)PARTICLE_OFFSETS.get(((Integer)pState.getValue((Property)CANDLES)).intValue());
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (Utils.mayPerformBlockAction((Player)player, (BlockPos)pos, (ItemStack)stack)) {
            Item item;
            if (stack.is(ItemTags.CANDLES) && (item = stack.getItem()) instanceof BlockItem) {
                CandleSkullBlockTile tile;
                BlockEntity blockEntity;
                BlockItem blockItem = (BlockItem)item;
                int count = (Integer)state.getValue((Property)CANDLES);
                if (count < 4 && CommonConfigs.SKULL_CANDLES_MULTIPLE.get().booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof CandleSkullBlockTile && (tile = (CandleSkullBlockTile)blockEntity).getCandle().getBlock().asItem() == stack.getItem()) {
                    SoundType sound = blockItem.getBlock().defaultBlockState().getSoundType();
                    level.playSound(player, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
                    stack.consume(1, (LivingEntity)player);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                    level.setBlock(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(count + 1)), 2);
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            return super.lightableInteractWithPlayerItem(state, level, pos, player, hand, stack);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean isLitUp(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)LIT);
    }

    public void setLitUp(BlockState state, LevelAccessor world, BlockPos pos, @Nullable Entity player, boolean lit) {
        world.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(lit)), 3);
    }

    public boolean canBeExtinguishedBy(ItemStack item) {
        return item.isEmpty() || super.canBeExtinguishedBy(item);
    }

    public void playExtinguishSound(LevelAccessor world, BlockPos pos) {
        world.playSound(null, pos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void spawnSmokeParticles(BlockState state, BlockPos pos, LevelAccessor level) {
        this.getParticleOffsets(state).forEach(vec3 -> level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + vec3.x(), (double)pos.getY() + vec3.y(), (double)pos.getZ() + vec3.z(), 0.0, (double)0.1f, 0.0));
    }

    public boolean tryWash(Level level, BlockPos pos, BlockState state, Vec3 hit) {
        Block n;
        CandleSkullBlockTile tile;
        BlockState c;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CandleSkullBlockTile && (c = (tile = (CandleSkullBlockTile)blockEntity).getCandle()) != null && (n = BlocksColorAPI.changeColor((Block)c.getBlock(), null)) != null && n != c.getBlock()) {
            tile.setCandle(n.withPropertiesOf(c));
            tile.setChanged();
            level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        return false;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return Utils.getTicker(type, ModRegistry.SKULL_CANDLE_TILE.get(), CandleSkullBlockTile::tick);
    }

    public void animateTick(BlockState state, Level level, BlockPos blockPos, RandomSource randomSource) {
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && (blockEntity = level.getBlockEntity(blockPos)) instanceof CandleSkullBlockTile) {
            CandleSkullBlockTile tile = (CandleSkullBlockTile)blockEntity;
            this.getParticleOffsets(state).forEach(vec3 -> this.addParticlesAndSound(tile.getParticle(), level, vec3.add((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), randomSource));
        }
    }

    protected void addParticlesAndSound(ParticleType<?> particle, Level level, Vec3 vec3, RandomSource randomSource) {
        float f = randomSource.nextFloat();
        if (f < 0.3f) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, vec3.x, vec3.y, vec3.z, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                level.playLocalSound(vec3.x + 0.5, vec3.y + 0.5, vec3.z + 0.5, SoundEvents.CANDLE_AMBIENT, SoundSource.BLOCKS, 1.0f + randomSource.nextFloat(), randomSource.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        level.addParticle((ParticleOptions)particle, vec3.x, vec3.y, vec3.z, 0.0, 0.0, 0.0);
    }
}

