/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.DyedItemColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiquidMixer {
    @Nullable
    public static SoftFluidStack mixPotions(SoftFluidStack firstFluid, SoftFluidStack secondFluid) {
        PotionContents tankFluidContent = (PotionContents)firstFluid.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        PotionContents newFluidContent = (PotionContents)secondFluid.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        int oldCount = firstFluid.getCount();
        int newCount = oldCount + secondFluid.getCount();
        ArrayList<MobEffectInstance> combinedEffects = new ArrayList<MobEffectInstance>();
        ArrayList<MobEffectInstance> existingEffects = new ArrayList<MobEffectInstance>();
        tankFluidContent.getAllEffects().forEach(existingEffects::add);
        ArrayList<MobEffectInstance> newEffects = new ArrayList<MobEffectInstance>();
        newFluidContent.getAllEffects().forEach(newEffects::add);
        if (newEffects.equals(existingEffects)) {
            return null;
        }
        float oldMult = (float)oldCount / (float)newCount;
        float newMult = 1.0f - oldMult;
        LiquidMixer.combineEffects(combinedEffects, existingEffects, oldMult);
        LiquidMixer.combineEffects(combinedEffects, newEffects, newMult);
        Map<Holder, MobEffectInstance> mergedMap = combinedEffects.stream().collect(Collectors.toMap(MobEffectInstance::getEffect, effectInstance -> effectInstance, LiquidMixer::mergeEffects));
        mergedMap.entrySet().removeIf(e -> ((MobEffectInstance)e.getValue()).getDuration() <= 0 || ((MobEffectInstance)e.getValue()).getAmplifier() < 0);
        int customPotionColor = PotionContents.getColor(mergedMap.values());
        PotionContents mergedContents = new PotionContents(Optional.empty(), Optional.of(customPotionColor), mergedMap.values().stream().toList());
        SoftFluidStack returnStack = firstFluid.copy();
        returnStack.set(DataComponents.POTION_CONTENTS, (Object)mergedContents);
        return returnStack;
    }

    @NotNull
    private static MobEffectInstance mergeEffects(MobEffectInstance e, MobEffectInstance e1) {
        return new MobEffectInstance(e.getEffect(), e.getDuration() + e1.getDuration(), (e.getAmplifier() + e1.getAmplifier()) / 2);
    }

    private static void combineEffects(List<MobEffectInstance> combinedEffects, List<MobEffectInstance> current, float mult) {
        for (MobEffectInstance e : current) {
            Holder effect = e.getEffect();
            MobEffectInstance newInstance = ((MobEffect)effect.value()).isInstantenous() ? new MobEffectInstance(effect, e.getDuration(), (int)((float)e.getAmplifier() * mult)) : new MobEffectInstance(effect, (int)((float)e.getDuration() * mult), e.getAmplifier());
            combinedEffects.add(newInstance);
        }
    }

    @Nullable
    public static SoftFluidStack mixDye(SoftFluidStack firstFluid, SoftFluidStack secondFluid) {
        DyedItemColor firstColor = (DyedItemColor)firstFluid.get(DataComponents.DYED_COLOR);
        DyedItemColor secondColor = (DyedItemColor)secondFluid.get(DataComponents.DYED_COLOR);
        if (firstColor == null || secondColor == null) {
            return null;
        }
        int oldAmount = firstFluid.getCount();
        int newAmount = secondFluid.getCount();
        int newColor = DyeBottleItem.mixColor(firstColor.rgb(), secondColor.rgb(), oldAmount, newAmount);
        SoftFluidStack returnStack = firstFluid.copy();
        returnStack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(newColor, true));
        return returnStack;
    }
}

