/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.platform.neoforge;

import com.mojang.brigadier.CommandDispatcher;
import com.qendolin.betterclouds.platform.EventHooks;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.common.NeoForge;

public class EventHooksImpl
extends EventHooks {
    private final IEventBus modEventBus;

    public EventHooksImpl(IEventBus modEventBus) {
        this.modEventBus = modEventBus;
    }

    @Override
    public void onClientStarted(Consumer<Minecraft> callback) {
        this.modEventBus.addListener(FMLLoadCompleteEvent.class, event -> {
            Minecraft client = Minecraft.getInstance();
            client.execute(() -> callback.accept(client));
        });
    }

    @Override
    public void onWorldJoin(Consumer<Minecraft> callback) {
        NeoForge.EVENT_BUS.addListener(ClientPlayerNetworkEvent.LoggingIn.class, event -> callback.accept(Minecraft.getInstance()));
    }

    @Override
    public void onClientResourcesReload(Supplier<PreparableReloadListener> supplier) {
        this.modEventBus.addListener(RegisterClientReloadListenersEvent.class, event -> event.registerReloadListener((PreparableReloadListener)supplier.get()));
    }

    @Override
    public void onClientTick(Consumer<Minecraft> callback) {
        NeoForge.EVENT_BUS.addListener(ClientTickEvent.Post.class, event -> {
            Minecraft client = Minecraft.getInstance();
            client.execute(() -> callback.accept(client));
        });
    }

    @Override
    public void onClientCommandRegistration(Consumer<CommandDispatcher<CommandSourceStack>> callback) {
        NeoForge.EVENT_BUS.addListener(RegisterClientCommandsEvent.class, event -> callback.accept(event.getDispatcher()));
    }
}

