/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.toast;

import de.theidler.create_mobile_packages.toast.CustomToast;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="create_mobile_packages")
public class ToastOverlayRenderer {
    private static final List<CustomToast> TOASTS = new ArrayList<CustomToast>();

    public static void showToast(CustomToast toast) {
        for (int i = 0; i < TOASTS.size(); ++i) {
            if (!ToastOverlayRenderer.TOASTS.get((int)i).uuid.equals(toast.uuid)) continue;
            TOASTS.set(i, toast);
            return;
        }
        TOASTS.add(toast);
    }

    public static void removeToast(UUID uuid) {
        TOASTS.removeIf(t -> t.uuid.equals(uuid));
    }

    public static void removeAllToasts() {
        TOASTS.clear();
    }

    @SubscribeEvent
    public static void onRenderGuiPost(RenderGuiEvent.Post event) {
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Minecraft mc = Minecraft.getInstance();
        int toastWidth = 160;
        int x = mc.getWindow().getGuiScaledWidth() - toastWidth - 10;
        int y = 10;
        TOASTS.removeIf(toast -> toast.lastUpdate < System.currentTimeMillis() - (long)toast.timeout);
        for (CustomToast toast2 : TOASTS) {
            guiGraphics.fill(x, y, x + toastWidth, y + 32, -1442840576);
            guiGraphics.renderItem(toast2.icon, x + 6, y + 6);
            guiGraphics.drawString(mc.font, toast2.title, x + 28, y + 6, 0xFFFFFF, false);
            guiGraphics.drawString(mc.font, toast2.subtitle, x + 28, y + 18, 0xAAAAAA, false);
            y += 36;
        }
    }
}

