/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.toast;

import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class CustomToast {
    public final UUID uuid;
    public final Component title;
    public final Component subtitle;
    public final ItemStack icon;
    public final long lastUpdate = System.currentTimeMillis();
    public final int timeout;
    public static final StreamCodec<RegistryFriendlyByteBuf, CustomToast> STREAM_CODEC = StreamCodec.of((buf, toast) -> {
        buf.writeUUID(toast.uuid);
        buf.writeUtf(toast.title.getString());
        buf.writeUtf(toast.subtitle.getString());
        buf.writeInt(toast.timeout);
        ItemStack.OPTIONAL_STREAM_CODEC.encode(buf, (Object)toast.icon);
    }, buf -> {
        UUID uuid = buf.readUUID();
        MutableComponent title = Component.literal((String)buf.readUtf());
        MutableComponent subtitle = Component.literal((String)buf.readUtf());
        int timeout = buf.readInt();
        ItemStack icon = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode(buf);
        return new CustomToast(uuid, (Component)title, (Component)subtitle, icon, timeout);
    });

    public CustomToast(UUID uuid, Component title, Component subtitle, ItemStack icon, int timeout) {
        this.uuid = uuid;
        this.title = title;
        this.subtitle = subtitle;
        this.icon = icon;
        this.timeout = timeout;
    }

    public CustomToast(UUID uuid, Component title, Component subtitle, ItemStack icon) {
        this(uuid, title, subtitle, icon, 5000);
    }
}

