/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.robo;

import de.theidler.create_mobile_packages.robo.VirtualRobo;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class RoboManager
extends SavedData {
    public Map<UUID, VirtualRobo> robos;

    public RoboManager() {
        this.init();
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ListTag robosList = new ListTag();
        for (VirtualRobo robo : this.robos.values()) {
            robosList.add((Object)robo.serializeNBT());
        }
        tag.put("robos", (Tag)robosList);
        return tag;
    }

    public static RoboManager load(CompoundTag tag, ServerLevel level) {
        RoboManager manager = new RoboManager();
        ListTag robosList = tag.getList("robos", 10);
        for (int i = 0; i < robosList.size(); ++i) {
            CompoundTag roboTag = robosList.getCompound(i);
            VirtualRobo robo = VirtualRobo.deserializeNBT(level, roboTag);
            manager.robos.put(robo.getId(), robo);
        }
        return manager;
    }

    public static RoboManager get(ServerLevel level) {
        return (RoboManager)level.getDataStorage().computeIfAbsent(new SavedData.Factory(RoboManager::new, (tag, provider) -> RoboManager.load(tag, level)), "create_mobile_packages_robo_manager");
    }

    public VirtualRobo get(UUID roboId) {
        return this.robos.get(roboId);
    }

    public void remove(UUID roboId) {
        this.robos.remove(roboId);
        this.setDirty();
    }

    public void add(VirtualRobo robo) {
        this.robos.put(robo.getId(), robo);
        this.setDirty();
    }

    public void tick(ServerLevel level) {
        this.robos.values().forEach(robo -> robo.tick(level));
        this.setDirty();
    }

    public UUID newRobo(ServerLevel level, ItemStack itemStack, BlockPos spawnPos, UUID logisticsNetworkId) {
        UUID id = UUID.randomUUID();
        VirtualRobo robo = new VirtualRobo(level, id, itemStack, spawnPos, logisticsNetworkId);
        this.add(robo);
        this.setDirty();
        return id;
    }

    private void init() {
        this.robos = new ConcurrentHashMap<UUID, VirtualRobo>();
    }
}

