/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.robo;

import de.theidler.create_mobile_packages.CMPHelper;
import de.theidler.create_mobile_packages.index.CMPItems;
import de.theidler.create_mobile_packages.robo.RoboTarget;
import de.theidler.create_mobile_packages.robo.VirtualRobo;
import de.theidler.create_mobile_packages.toast.CustomToast;
import de.theidler.create_mobile_packages.toast.ShowToastOnClientPacket;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class PlayerTarget
implements RoboTarget {
    private final Player player;

    public PlayerTarget(Player player) {
        this.player = player;
    }

    public static PlayerTarget fromAddress(ServerLevel level, String address) {
        ServerPlayer player = level.getPlayers(p -> CMPHelper.doesAddressMatchPlayer((Player)p, address)).stream().findFirst().orElse(null);
        return new PlayerTarget((Player)player);
    }

    @Override
    public Vec3 getTargetPos() {
        return this.player.position();
    }

    @Override
    public Player asPlayer() {
        return this.player;
    }

    @Override
    public boolean isValid() {
        return this.player != null && this.player.isAlive();
    }

    @Override
    public void setETA(VirtualRobo robo, int eta) {
        CustomToast toast = new CustomToast(robo.getId(), (Component)Component.translatable((String)"create_mobile_packages.toast.robo_bee_on_the_way"), (Component)Component.translatable((String)"create_mobile_packages.toast.eta", (Object[])new Object[]{eta}), CMPItems.ROBO_BEE.asStack(), 1100);
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CatnipServices.NETWORK.sendToClient(serverPlayer, (CustomPacketPayload)new ShowToastOnClientPacket(toast));
        }
    }
}

