/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.robo_bee;

import com.simibubi.create.content.logistics.box.PackageItem;
import de.theidler.create_mobile_packages.index.config.CMPConfigs;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.StockCheckingItem;
import de.theidler.create_mobile_packages.robo.RoboManager;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RoboBeeItem
extends StockCheckingItem {
    public RoboBeeItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (super.useOn(context) != InteractionResult.PASS) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack offhandItem = player.getOffhandItem();
        BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
        ItemStack packageItem = ItemStack.EMPTY;
        if (PackageItem.isPackage((ItemStack)offhandItem) && ((Boolean)CMPConfigs.server().allowRoboBeeSpawnPackageTransport.get()).booleanValue()) {
            packageItem = offhandItem.copy();
            player.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            UUID networkId = RoboBeeItem.networkFromStack(context.getItemInHand());
            UUID finalNetworkId = networkId != null ? networkId : UUID.randomUUID();
            RoboManager.get(serverLevel).newRobo(serverLevel, packageItem, pos, finalNetworkId);
        }
        context.getItemInHand().shrink(1);
        return InteractionResult.SUCCESS;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        return InteractionResultHolder.pass((Object)pPlayer.getItemInHand(pHand));
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.create_mobile_packages.robo_bee.robo_bee").withStyle(ChatFormatting.GRAY));
        if (((Boolean)CMPConfigs.server().allowRoboBeeSpawnPackageTransport.get()).booleanValue()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.create_mobile_packages.robo_bee.package_transport").withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

