/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.entities.robo_entity;

import de.theidler.create_mobile_packages.index.config.CMPConfigs;
import de.theidler.create_mobile_packages.robo.RoboManager;
import de.theidler.create_mobile_packages.robo.VirtualRobo;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RoboEntity
extends Mob {
    private static final EntityDataAccessor<Float> ROT_YAW = SynchedEntityData.defineId(RoboEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.defineId(RoboEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Float> PACKAGE_HEIGHT_SCALE = SynchedEntityData.defineId(RoboEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public UUID linkedId;

    public RoboEntity(EntityType<? extends Mob> type, Level level, UUID linkedId) {
        super(type, level);
        this.linkedId = linkedId;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ROT_YAW, (Object)Float.valueOf(this.getYRot()));
        builder.define(DATA_ITEM_STACK, (Object)ItemStack.EMPTY);
        builder.define(PACKAGE_HEIGHT_SCALE, (Object)Float.valueOf(0.0f));
    }

    public void tick() {
        ServerLevel serverLevel;
        super.tick();
        this.setYRot(((Float)this.entityData.get(ROT_YAW)).floatValue());
        Level level = this.level();
        if (level instanceof ServerLevel && RoboManager.get(serverLevel = (ServerLevel)level).get(this.linkedId) == null) {
            this.discard();
        }
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean save(@Nonnull CompoundTag compound) {
        return false;
    }

    public void addAdditionalSaveData(@Nonnull CompoundTag compound) {
    }

    public void readAdditionalSaveData(@Nonnull CompoundTag compound) {
    }

    public boolean shouldBeSaved() {
        return false;
    }

    private void updateNametag(VirtualRobo virtualRobo) {
        if (this.level().isClientSide) {
            return;
        }
        if (!((Boolean)CMPConfigs.server().displayNametag.get()).booleanValue()) {
            this.setCustomName(null);
            this.setCustomNameVisible(false);
        } else if (virtualRobo.getTargetAddress() != null && !virtualRobo.getTargetAddress().isBlank()) {
            this.setCustomName((Component)Component.literal((String)("-> " + virtualRobo.getTargetAddress())));
            this.setCustomNameVisible(true);
        } else if (virtualRobo.getTarget() != null && virtualRobo.getTarget().asBeePortBlockEntity() != null) {
            BlockPos pos = virtualRobo.getTarget().asBeePortBlockEntity().getBlockPos();
            this.setCustomName((Component)Component.literal((String)("-> [" + pos.getX() + ", " + pos.getY() + ", " + pos.getZ() + "]")));
            this.setCustomNameVisible(true);
        } else {
            this.setCustomName((Component)Component.translatable((String)"entity.create_mobile_packages.robo_bee.no_valid_target"));
            this.setCustomNameVisible(true);
        }
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.entityData.get(DATA_ITEM_STACK);
    }

    public float getPackageHeightScale() {
        return ((Float)this.entityData.get(PACKAGE_HEIGHT_SCALE)).floatValue();
    }

    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        return false;
    }

    public boolean isOnFire() {
        return false;
    }

    public void syncFromVirtual(VirtualRobo virtualRobo) {
        this.updateNametag(virtualRobo);
        this.setPos(virtualRobo.getCurrentPos());
        this.setXRot(virtualRobo.getPitch());
        this.entityData.set(ROT_YAW, (Object)Float.valueOf(virtualRobo.getYaw()));
        this.entityData.set(DATA_ITEM_STACK, (Object)virtualRobo.getItemStack());
        this.entityData.set(PACKAGE_HEIGHT_SCALE, (Object)Float.valueOf(virtualRobo.getPackageHeightScale()));
    }
}

