/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.entities.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.theidler.create_mobile_packages.CreateMobilePackages;
import de.theidler.create_mobile_packages.entities.RoboBeeEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.jetbrains.annotations.NotNull;

public class RoboBeeModel<T extends RoboBeeEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(CreateMobilePackages.asResource("robobeemodel"), "main");
    private final ModelPart stinger;
    private final ModelPart wing1;
    private final ModelPart rotor1;
    private final ModelPart wing2;
    private final ModelPart rotor2;
    private final ModelPart bb_main;

    public RoboBeeModel(ModelPart root) {
        this.stinger = root.getChild("stinger");
        this.wing1 = root.getChild("wing1");
        this.rotor1 = this.wing1.getChild("rotor1");
        this.wing2 = root.getChild("wing2");
        this.rotor2 = this.wing2.getChild("rotor2");
        this.bb_main = root.getChild("bb_main");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition stinger = partdefinition.addOrReplaceChild("stinger", CubeListBuilder.create().texOffs(30, 7).addBox(0.0f, 0.0f, 4.0f, 0.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)18.0f, (float)1.0f));
        PartDefinition wing1 = partdefinition.addOrReplaceChild("wing1", CubeListBuilder.create().texOffs(37, 3).addBox(2.0f, -1.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(37, 0).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(37, 3).addBox(-3.0f, -1.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(37, 0).addBox(-3.0f, -1.0f, 2.0f, 6.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.6f, (float)14.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition rotor1 = wing1.addOrReplaceChild("rotor1", CubeListBuilder.create().texOffs(-4, 18).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wing2 = partdefinition.addOrReplaceChild("wing2", CubeListBuilder.create().texOffs(37, 3).addBox(2.0f, -1.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(37, 0).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(37, 3).addBox(-3.0f, -1.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(37, 0).addBox(-3.0f, -1.0f, 2.0f, 6.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)14.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition rotor2 = wing2.addOrReplaceChild("rotor2", CubeListBuilder.create().texOffs(-4, 18).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bb_main = partdefinition.addOrReplaceChild("bb_main", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -9.0f, -5.0f, 7.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(2, 3).addBox(-2.0f, -9.0f, -8.0f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(2, 0).addBox(2.0f, -9.0f, -8.0f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@NotNull RoboBeeEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float rotation;
        float rotationSpeed = 20.0f;
        this.rotor1.yRot = rotation = ageInTicks * rotationSpeed;
        this.rotor2.yRot = -rotation;
    }

    public void renderToBuffer(PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int i, int i1, int i2) {
        poseStack.pushPose();
        poseStack.scale(0.8f, 0.8f, 0.8f);
        poseStack.translate(0.0f, 0.4f, 0.0f);
        this.stinger.render(poseStack, vertexConsumer, i, i1, i2);
        this.wing1.render(poseStack, vertexConsumer, i, i1, i2);
        this.wing2.render(poseStack, vertexConsumer, i, i1, i2);
        this.bb_main.render(poseStack, vertexConsumer, i, i1, i2);
        poseStack.popPose();
    }
}

