/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.entities;

import de.theidler.create_mobile_packages.entities.robo_entity.RoboEntity;
import de.theidler.create_mobile_packages.robo.RoboManager;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RoboBeeEntity
extends RoboEntity {
    public RoboBeeEntity(EntityType<? extends Mob> entityEntityType, Level level, UUID linkedId) {
        super(entityEntityType, level, linkedId);
        this.setNoGravity(true);
        this.noPhysics = true;
        this.setNoAi(true);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
    }

    public boolean canCollideWith(@NotNull Entity entity) {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public void push(@NotNull Entity entity) {
    }

    protected void doPush(@NotNull Entity entity) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.0);
    }

    public static RoboBeeEntity createEmpty(EntityType<? extends Mob> type, Level level) {
        UUID linkedId = UUID.randomUUID();
        return new RoboBeeEntity(type, level, linkedId);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos spawnPos = this.blockPosition();
            RoboManager.get(serverLevel).newRobo(serverLevel, this.getItemStack(), spawnPos, this.linkedId);
        }
    }
}

