/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.compat.jei;

import com.simibubi.create.content.logistics.stockTicker.CraftableBigItemStack;
import com.simibubi.create.foundation.blockEntity.ItemHandlerContainer;
import com.simibubi.create.foundation.utility.CreateLang;
import de.theidler.create_mobile_packages.index.CMPMenuTypes;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.PortableStockTickerMenu;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.PortableStockTickerScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.library.transfer.RecipeTransferErrorMissingSlots;
import mezz.jei.library.transfer.RecipeTransferErrorTooltip;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.zznty.create_factory_abstractions.CreateFactoryAbstractions;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericIngredient;
import ru.zznty.create_factory_abstractions.api.generic.stack.GenericStack;
import ru.zznty.create_factory_abstractions.compat.jei.IngredientTransfer;
import ru.zznty.create_factory_abstractions.compat.jei.TransferOperation;
import ru.zznty.create_factory_abstractions.compat.jei.TransferOperationsResult;
import ru.zznty.create_factory_abstractions.generic.support.CraftableGenericStack;
import ru.zznty.create_factory_abstractions.generic.support.GenericInventorySummary;

public class DroneControllerTransferHandler
implements IUniversalRecipeTransferHandler<PortableStockTickerMenu> {
    private final IJeiHelpers helpers;

    public DroneControllerTransferHandler(IJeiHelpers helpers) {
        this.helpers = helpers;
    }

    @NotNull
    public Class<? extends PortableStockTickerMenu> getContainerClass() {
        return PortableStockTickerMenu.class;
    }

    @NotNull
    public Optional<MenuType<PortableStockTickerMenu>> getMenuType() {
        return Optional.of((MenuType)CMPMenuTypes.PORTABLE_STOCK_TICKER_MENU.get());
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull PortableStockTickerMenu container, @NotNull Object object, @NotNull IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        Level level = player.level();
        if (!(object instanceof RecipeHolder)) {
            return null;
        }
        RecipeHolder recipe = (RecipeHolder)object;
        MutableObject result = new MutableObject();
        if (level.isClientSide()) {
            CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> result.setValue((Object)this.transferRecipeOnClient(container, recipe, recipeSlots, player, maxTransfer, doTransfer)));
        }
        return (IRecipeTransferError)result.getValue();
    }

    private IRecipeTransferError transferRecipeOnClient(PortableStockTickerMenu container, RecipeHolder<Recipe<?>> recipeHolder, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        Object object = container.screenReference;
        if (!(object instanceof PortableStockTickerScreen)) {
            return null;
        }
        PortableStockTickerScreen screen = (PortableStockTickerScreen)((Object)object);
        Recipe recipe = recipeHolder.value();
        for (CraftableGenericStack cbis : screen.recipesToOrder) {
            if (cbis.asStack().recipe != recipe) continue;
            return new RecipeTransferErrorTooltip((Component)CreateLang.translate((String)"gui.stock_keeper.already_ordering_recipe", (Object[])new Object[0]).component());
        }
        if (screen.itemsToOrder.size() >= 9) {
            return new RecipeTransferErrorTooltip((Component)CreateLang.translate((String)"gui.stock_keeper.slots_full", (Object[])new Object[0]).component());
        }
        GenericInventorySummary summary = screen.stockSnapshot();
        List availableStacks = summary.get();
        ItemHandlerContainer outputDummy = new ItemHandlerContainer((IItemHandlerModifiable)new ItemStackHandler(9));
        ArrayList<Slot> craftingSlots = new ArrayList<Slot>();
        for (int i = 0; i < outputDummy.getContainerSize(); ++i) {
            craftingSlots.add(new Slot((Container)outputDummy, i, 0, 0));
        }
        TransferOperationsResult transferOperations = IngredientTransfer.getRecipeTransferOperations((IIngredientManager)this.helpers.getIngredientManager(), (List)availableStacks, (List)recipeSlots.getSlotViews(RecipeIngredientRole.INPUT), craftingSlots);
        if (!transferOperations.missingItems().isEmpty()) {
            return new RecipeTransferErrorMissingSlots((Component)CreateLang.translate((String)"gui.stock_keeper.not_in_stock", (Object[])new Object[0]).component(), (Collection)transferOperations.missingItems());
        }
        if ((long)screen.itemsToOrder.size() + transferOperations.results().stream().mapToInt(TransferOperation::from).distinct().count() >= 9L) {
            return new RecipeTransferErrorTooltip((Component)CreateLang.translate((String)"gui.stock_keeper.slots_full", (Object[])new Object[0]).component());
        }
        if (!doTransfer) {
            return null;
        }
        RegistryAccess registryAccess = player.level().registryAccess();
        CraftableBigItemStack cbis = new CraftableBigItemStack(recipe.getResultItem((HolderLookup.Provider)registryAccess), recipe);
        CraftableGenericStack ingredientStack = CraftableGenericStack.of((CraftableBigItemStack)cbis);
        ingredientStack.setAmount(0);
        if (CreateFactoryAbstractions.EXTENSIBILITY_AVAILABLE) {
            for (TransferOperation operation : transferOperations.results()) {
                IIngredientHelper helper = this.helpers.getIngredientManager().getIngredientHelper(operation.selectedIngredient().getType());
                ingredientStack.ingredients().add(GenericIngredient.of((GenericStack)((GenericStack)availableStacks.get(operation.from())).withAmount((int)helper.getAmount(operation.selectedIngredient().getIngredient()))));
            }
            for (IRecipeSlotView slotView : recipeSlots.getSlotViews(RecipeIngredientRole.OUTPUT)) {
                Optional ingredient;
                Optional displayedIngredient = slotView.getDisplayedIngredient();
                if (displayedIngredient.isEmpty() || (ingredient = IngredientTransfer.tryConvert((IIngredientManager)this.helpers.getIngredientManager(), (ITypedIngredient)((ITypedIngredient)displayedIngredient.get()))).isEmpty()) continue;
                ingredientStack.results(registryAccess).add((GenericStack)ingredient.get());
            }
            if (cbis.stack.isEmpty() && !ingredientStack.results(registryAccess).isEmpty()) {
                ingredientStack.set(((GenericStack)ingredientStack.results(registryAccess).getFirst()).withAmount(0));
            }
        }
        screen.recipesToOrder.add(ingredientStack);
        screen.searchBox.setValue("");
        screen.refreshSearchNextTick = true;
        screen.requestCraftable(ingredientStack, maxTransfer && !cbis.stack.isEmpty() ? cbis.stack.getMaxStackSize() : 1);
        return null;
    }
}

