/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import noobanidus.mods.lootr.common.api.LootrAPI;

public class ConfigManagerBase {
    protected static Set<String> validateStringList(Collection<? extends String> incomingList, String listKey) {
        HashSet<String> validatedList = new HashSet<String>();
        for (String string : incomingList) {
            if (string == null || string.isEmpty()) {
                LootrAPI.LOG.error("Error found when validating a configuration list for '" + listKey + "'. One of the entries is null or empty and cannot be converted to a String.");
                continue;
            }
            validatedList.add(string);
        }
        return validatedList;
    }

    protected static Set<ResourceKey<Level>> validateDimensions(Collection<? extends String> incomingList, String listKey) {
        return ConfigManagerBase.validateResourceKeyList(incomingList, listKey, o -> ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)o));
    }

    protected static <T> Set<ResourceKey<T>> validateResourceKeyList(Collection<? extends String> incomingList, String listKey, Function<ResourceLocation, ResourceKey<T>> builder) {
        HashSet<ResourceKey<T>> validatedList = new HashSet<ResourceKey<T>>();
        for (String string : incomingList) {
            ResourceLocation location;
            if (string == null || string.isEmpty()) {
                throw new RuntimeException("Error found when validating a configuration list for '" + listKey + "'. One of the entries is null or empty and cannot be converted to a ResourceLocation.");
            }
            try {
                location = ResourceLocation.parse((String)string);
            }
            catch (Exception e) {
                throw new RuntimeException("Error found when validating a configuration list for '" + listKey + "'. The value found in the list, '" + string + "', is not a valid ResourceLocation.", e);
            }
            try {
                validatedList.add(builder.apply(location));
            }
            catch (Exception e) {
                throw new RuntimeException("Error found when validating a configuration list for '" + listKey + "'. The value found in the list, '" + string + "', is not valid to create a ResourceKey.", e);
            }
        }
        return validatedList;
    }
}

