/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.peripheral.monitor.ServerMonitor;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jspecify.annotations.Nullable;

public final class MonitorWatcher {
    private static final Queue<MonitorBlockEntity> watching = new ArrayDeque<MonitorBlockEntity>();

    private MonitorWatcher() {
    }

    static void enqueue(MonitorBlockEntity monitor) {
        if (monitor.enqueued) {
            return;
        }
        monitor.enqueued = true;
        monitor.cached = null;
        watching.add(monitor);
    }

    public static void onWatch(LevelChunk chunk, ServerPlayer player) {
        for (BlockEntity te : chunk.getBlockEntities().values()) {
            MonitorBlockEntity monitor;
            ServerMonitor serverMonitor;
            if (!(te instanceof MonitorBlockEntity) || (serverMonitor = MonitorWatcher.getMonitor(monitor = (MonitorBlockEntity)te)) == null || monitor.enqueued) continue;
            TerminalState state = MonitorWatcher.getState(monitor, serverMonitor);
            ServerNetworking.sendToPlayer(new MonitorClientMessage(monitor.getBlockPos(), Optional.ofNullable(state)), player);
        }
    }

    public static void onTick() {
        MonitorBlockEntity tile;
        boolean obeyLimit;
        long limit = Config.monitorBandwidth;
        boolean bl = obeyLimit = limit > 0L;
        while (!(obeyLimit && limit <= 0L || (tile = watching.poll()) == null)) {
            LevelChunk chunk;
            ServerLevel level;
            tile.enqueued = false;
            ServerMonitor monitor = MonitorWatcher.getMonitor(tile);
            if (monitor == null) continue;
            BlockPos pos = tile.getBlockPos();
            Level level2 = tile.getLevel();
            if (!(level2 instanceof ServerLevel) || level.getChunkSource().chunkMap.getPlayers((chunk = (level = (ServerLevel)level2).getChunkAt(pos)).getPos(), false).isEmpty()) continue;
            TerminalState state = MonitorWatcher.getState(tile, monitor);
            ServerNetworking.sendToAllTracking(new MonitorClientMessage(pos, Optional.ofNullable(state)), chunk);
            limit -= state == null ? 0L : (long)state.size();
        }
    }

    private static @Nullable ServerMonitor getMonitor(MonitorBlockEntity monitor) {
        return !monitor.isRemoved() && monitor.getXIndex() == 0 && monitor.getYIndex() == 0 ? monitor.getCachedServerMonitor() : null;
    }

    private static @Nullable TerminalState getState(MonitorBlockEntity tile, ServerMonitor monitor) {
        TerminalState state = tile.cached;
        if (state == null) {
            state = tile.cached = TerminalState.create(monitor.getTerminal());
        }
        return state;
    }
}

