/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wireless;

import com.mojang.serialization.MapCodec;
import dan200.computercraft.shared.peripheral.modem.ModemShapes;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlockEntity;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.util.BlockCodecs;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class WirelessModemBlock
extends DirectionalBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    private static final MapCodec<WirelessModemBlock> CODEC = BlockCodecs.blockWithBlockEntityCodec(WirelessModemBlock::new, x -> x.type);
    public static final BooleanProperty ON = BooleanProperty.create((String)"on");
    private final RegistryEntry<? extends BlockEntityType<? extends WirelessModemBlockEntity>> type;

    public WirelessModemBlock(BlockBehaviour.Properties settings, RegistryEntry<? extends BlockEntityType<? extends WirelessModemBlockEntity>> type) {
        super(settings);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ON, (Comparable)Boolean.valueOf(false))).setValue((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ON, WaterloggableHelpers.WATERLOGGED});
    }

    protected MapCodec<? extends WirelessModemBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockView, BlockPos blockPos, CollisionContext context) {
        return ModemShapes.getBounds((Direction)blockState.getValue((Property)FACING));
    }

    protected FluidState getFluidState(BlockState state) {
        return WaterloggableHelpers.getFluidState(state);
    }

    protected BlockState updateShape(BlockState state, Direction side, BlockState otherState, LevelAccessor world, BlockPos pos, BlockPos otherPos) {
        WaterloggableHelpers.updateShape(state, world, pos);
        return side == state.getValue((Property)FACING) && !state.canSurvive((LevelReader)world, pos) ? state.getFluidState().createLegacyBlock() : state;
    }

    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return ModemShapes.canSupport(world, pos.relative(facing), facing.getOpposite());
    }

    public @Nullable BlockState getStateForPlacement(BlockPlaceContext placement) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)placement.getClickedFace().getOpposite())).setValue((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(WaterloggableHelpers.getFluidStateForPlacement(placement)));
    }

    protected BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof WirelessModemBlockEntity) {
            WirelessModemBlockEntity modem = (WirelessModemBlockEntity)te;
            modem.blockTick();
        }
    }

    public @Nullable BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)this.type.get()).create(blockPos, blockState);
    }
}

