/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import java.util.Iterator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class ChatTableClientMessage
implements NetworkMessage<ClientNetworkContext> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ChatTableClientMessage> STREAM_CODEC = StreamCodec.ofMember(ChatTableClientMessage::write, ChatTableClientMessage::new);
    private static final int MAX_LEN = 16;
    private final TableBuilder table;

    public ChatTableClientMessage(TableBuilder table) {
        if (table.getColumns() < 0) {
            throw new IllegalStateException("Cannot send an empty table");
        }
        this.table = table;
    }

    private ChatTableClientMessage(RegistryFriendlyByteBuf buf) {
        TableBuilder table;
        int i;
        String id = buf.readUtf(16);
        int columns = buf.readVarInt();
        if (buf.readBoolean()) {
            Component[] headers = new Component[columns];
            for (i = 0; i < columns; ++i) {
                headers[i] = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
            }
            table = new TableBuilder(id, headers);
        } else {
            table = new TableBuilder(id);
        }
        int rows = buf.readVarInt();
        for (i = 0; i < rows; ++i) {
            Component[] row = new Component[columns];
            for (int j = 0; j < columns; ++j) {
                row[j] = (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf);
            }
            table.row(row);
        }
        table.setAdditional(buf.readVarInt());
        this.table = table;
    }

    private void write(RegistryFriendlyByteBuf buf) {
        buf.writeUtf(this.table.getId(), 16);
        buf.writeVarInt(this.table.getColumns());
        buf.writeBoolean(this.table.getHeaders() != null);
        if (this.table.getHeaders() != null) {
            for (Component header : this.table.getHeaders()) {
                ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)header);
            }
        }
        buf.writeVarInt(this.table.getRows().size());
        Iterator<Component[]> iterator = this.table.getRows().iterator();
        while (iterator.hasNext()) {
            Component[] row;
            for (Component column : row = (Component[])iterator.next()) {
                ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)column);
            }
        }
        buf.writeVarInt(this.table.getAdditional());
    }

    @Override
    public void handle(ClientNetworkContext context) {
        context.handleChatTable(this.table);
    }

    public CustomPacketPayload.Type<ChatTableClientMessage> type() {
        return NetworkMessages.CHAT_TABLE;
    }
}

