/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import java.util.List;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;

public class TipOverlay {
    public static List<MutableComponent> lastTip;
    public static int hoverTicks;
    public static int deltaX;
    public static int deltaY;

    public static void register(@NotNull RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.HOTBAR, CCGUtil.getCCGRes("tip_overlay"), TipOverlay::renderOverlay);
    }

    public static void renderOverlay(GuiGraphics graphics, DeltaTracker deltaTracker) {
        if (CCGUtil.mc.options.hideGui) {
            return;
        }
        if (hoverTicks == 0 || lastTip == null) {
            return;
        }
        int x = graphics.guiWidth() / 2 + deltaX;
        int y = graphics.guiHeight() - 75 - lastTip.size() * 12 + deltaY;
        float alpha = hoverTicks > 5 ? (float)(11 - hoverTicks) / 5.0f : Math.min(1.0f, (float)hoverTicks / 5.0f);
        Color color = new Color(0xFFFFFF).setAlpha(alpha);
        Color titleColor = new Color(16505981).setAlpha(alpha);
        int i = 0;
        for (MutableComponent component : lastTip) {
            graphics.drawString(CCGUtil.mc.font, (Component)component, x - CCGUtil.mc.font.width((FormattedText)component) / 2, y + i * 12, (i == 0 ? titleColor : color).getRGB());
            ++i;
        }
    }

    public static void show(List<MutableComponent> tip, int x, int y) {
        if (CCGUtil.mc.screen != null || CCGUtil.hasActivedValueBox()) {
            return;
        }
        hoverTicks = hoverTicks == 0 ? 11 : Math.max(hoverTicks, 6);
        lastTip = tip;
        deltaX = x;
        deltaY = y;
    }

    public static void show(List<MutableComponent> tip) {
        TipOverlay.show(tip, 0, 0);
    }

    public static void tick(ClientTickEvent.Post ignoredEvent) {
        if (hoverTicks > 0) {
            --hoverTicks;
        }
    }
}

