/*
 * Decompiled with CFR 0.152.
 */
package io.github.forgestove.create_cyber_goggles.core.event;

import com.simibubi.create.content.contraptions.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.chassis.LinearChassisBlock;
import com.simibubi.create.content.contraptions.wrench.RadialWrenchMenuSubmitPacket;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import com.simibubi.create.content.logistics.tableCloth.TableClothBlockEntity;
import io.github.forgestove.create_cyber_goggles.CCG;
import io.github.forgestove.create_cyber_goggles.core.event.CCGKey;
import io.github.forgestove.create_cyber_goggles.core.event.TipOverlay;
import io.github.forgestove.create_cyber_goggles.core.util.CCGLang;
import io.github.forgestove.create_cyber_goggles.core.util.CCGUtil;
import io.github.forgestove.create_cyber_goggles.core.util.TableClothUtil;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class PlayerInteract {
    private static long lastDismantleTime;
    private static long dismantleDelay;
    private static long lastTick;

    public static void tick(ClientTickEvent.Pre ignoredEvent) {
        PlayerInteract.wrench();
        PlayerInteract.encasedCogWheel();
        PlayerInteract.enacesdPipe();
        PlayerInteract.chassis();
        PlayerInteract.tableCloth();
    }

    public static void leftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (CCGUtil.isServer()) {
            return;
        }
        PlayerInteract.wrench(event);
    }

    public static void rightClick(PlayerInteractEvent.RightClickBlock event) {
        if (CCGUtil.isServer()) {
            return;
        }
        PlayerInteract.enacesdPipe(event);
        PlayerInteract.encasedCogWheel(event);
        PlayerInteract.chassis(event);
    }

    private static void wrench() {
        if (dismantleDelay < 10L) {
            ++dismantleDelay;
        }
    }

    private static void wrench(PlayerInteractEvent.LeftClickBlock event) {
        InteractionHand handWithWrench;
        boolean canDismantle;
        if (!CCG.CONFIG.wrench.leftClickFastDismantle) {
            return;
        }
        if (dismantleDelay > 0L) {
            --dismantleDelay;
        }
        boolean bl = canDismantle = System.currentTimeMillis() - lastDismantleTime > dismantleDelay * 20L;
        if (!canDismantle) {
            return;
        }
        PlayerInteractEvent.LeftClickBlock.Action action = event.getAction();
        if (action != PlayerInteractEvent.LeftClickBlock.Action.START && action != PlayerInteractEvent.LeftClickBlock.Action.CLIENT_HOLD) {
            return;
        }
        LocalPlayer player = CCGUtil.mc.player;
        if (player == null || player.isCreative() || CCGUtil.mc.gameMode == null) {
            return;
        }
        Object object = player.getMainHandItem().getItem() instanceof WrenchItem ? InteractionHand.MAIN_HAND : (handWithWrench = player.getOffhandItem().getItem() instanceof WrenchItem ? InteractionHand.OFF_HAND : null);
        if (handWithWrench == null) {
            return;
        }
        if (!(CCGUtil.getBlock() instanceof IWrenchable)) {
            return;
        }
        BlockHitResult result = CCGUtil.getBlockHitResult();
        if (result == null) {
            return;
        }
        CCGUtil.sendAction(ServerboundPlayerCommandPacket.Action.PRESS_SHIFT_KEY);
        CCGUtil.mc.gameMode.useItemOn(player, handWithWrench, result);
        CCGUtil.sendAction(ServerboundPlayerCommandPacket.Action.RELEASE_SHIFT_KEY);
        lastDismantleTime = System.currentTimeMillis();
        event.setCanceled(true);
    }

    private static void encasedCogWheel() {
        if (!CCG.CONFIG.wrench.betterEncasedCogwheel) {
            return;
        }
        EncasedCogwheelBlock ecb = CCGUtil.getBlock(EncasedCogwheelBlock.class);
        if (ecb == null) {
            return;
        }
        BlockHitResult bhr = CCGUtil.getBlockHitResult();
        if (CCGUtil.mc.level == null || bhr == null) {
            return;
        }
        if (ecb.getRotationAxis(CCGUtil.mc.level.getBlockState(bhr.getBlockPos())) != bhr.getDirection().getAxis()) {
            return;
        }
        PlayerInteract.showCommonTip("message.openState");
    }

    private static void encasedCogWheel(PlayerInteractEvent.RightClickBlock event) {
        if (!CCG.CONFIG.wrench.betterEncasedCogwheel) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getLevel().getBlockState(pos);
        if (!(state.getBlock() instanceof EncasedCogwheelBlock) || event.getHand() != InteractionHand.MAIN_HAND || CCGUtil.mc.player == null || CCGUtil.hasItemInHand()) {
            return;
        }
        Direction clickedFace = event.getHitVec().getDirection();
        if (CCGKey.interactOpposite.isDown()) {
            clickedFace = clickedFace.getOpposite();
        }
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS);
        if (clickedFace.getAxis() != axis) {
            return;
        }
        BooleanProperty booleanProperty = clickedFace.getAxisDirection() == Direction.AxisDirection.POSITIVE ? EncasedCogwheelBlock.TOP_SHAFT : EncasedCogwheelBlock.BOTTOM_SHAFT;
        CCGUtil.sendToServer((CustomPacketPayload)new RadialWrenchMenuSubmitPacket(pos, (BlockState)state.cycle((Property)booleanProperty)));
        CCGUtil.mc.player.swing(CCGUtil.mc.player.getUsedItemHand());
    }

    private static void enacesdPipe() {
        if (!CCG.CONFIG.wrench.betterEncasedPipe) {
            return;
        }
        if (CCGUtil.getBlock(EncasedPipeBlock.class) == null) {
            return;
        }
        PlayerInteract.showCommonTip("message.openState");
    }

    private static void enacesdPipe(PlayerInteractEvent.RightClickBlock event) {
        if (!CCG.CONFIG.wrench.betterEncasedPipe) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getLevel().getBlockState(pos);
        if (!(state.getBlock() instanceof EncasedPipeBlock) || event.getHand() != InteractionHand.MAIN_HAND || CCGUtil.mc.player == null || CCGUtil.hasItemInHand()) {
            return;
        }
        Direction clickedFace = event.getHitVec().getDirection();
        if (CCGKey.interactOpposite.isDown()) {
            clickedFace = clickedFace.getOpposite();
        }
        BooleanProperty booleanProperty = (BooleanProperty)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(clickedFace);
        CCGUtil.sendToServer((CustomPacketPayload)new RadialWrenchMenuSubmitPacket(pos, (BlockState)state.cycle((Property)booleanProperty)));
        CCGUtil.mc.player.swing(CCGUtil.mc.player.getUsedItemHand());
    }

    private static void chassis() {
        if (!CCG.CONFIG.wrench.betterChassis) {
            return;
        }
        if (CCGUtil.mc.level == null) {
            return;
        }
        AbstractChassisBlock acb = CCGUtil.getBlock(AbstractChassisBlock.class);
        if (acb == null) {
            return;
        }
        BlockHitResult bhr = CCGUtil.getBlockHitResult();
        if (bhr == null || acb.getGlueableSide(CCGUtil.mc.level.getBlockState(bhr.getBlockPos()), bhr.getDirection()) == null) {
            return;
        }
        PlayerInteract.showCommonTip("message.glueState");
    }

    private static void chassis(PlayerInteractEvent.RightClickBlock event) {
        BooleanProperty booleanProperty;
        if (!CCG.CONFIG.wrench.betterChassis) {
            return;
        }
        if (CCGUtil.hasActivedValueBox()) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getLevel().getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof AbstractChassisBlock)) {
            return;
        }
        AbstractChassisBlock acb = (AbstractChassisBlock)block;
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        if (CCGUtil.mc.player == null) {
            return;
        }
        if (CCGUtil.mc.player.isShiftKeyDown()) {
            return;
        }
        if (CCGUtil.hasItemInHand()) {
            return;
        }
        Direction clickedFace = event.getHitVec().getDirection();
        if (CCGKey.interactOpposite.isDown()) {
            clickedFace = clickedFace.getOpposite();
            Level level = event.getLevel();
            EnumProperty axisProp = RotatedPillarBlock.AXIS;
            Direction.Axis baseAxis = state.hasProperty((Property)axisProp) ? (Direction.Axis)state.getValue((Property)axisProp) : null;
            BlockPos probePos = pos.relative(clickedFace);
            BlockState probeState = level.getBlockState(probePos);
            AbstractChassisBlock targetAcb = acb;
            if (LinearChassisBlock.isChassis((BlockState)state) && LinearChassisBlock.sameKind((BlockState)state, (BlockState)probeState)) {
                Block block2;
                while ((block2 = probeState.getBlock()) instanceof LinearChassisBlock) {
                    Direction.Axis probeAxis;
                    LinearChassisBlock lcb = (LinearChassisBlock)block2;
                    Direction.Axis axis = probeAxis = probeState.hasProperty((Property)axisProp) ? (Direction.Axis)probeState.getValue((Property)axisProp) : null;
                    if (probeAxis == null || probeAxis != baseAxis) break;
                    pos = probePos;
                    state = probeState;
                    targetAcb = lcb;
                    probePos = probePos.relative(clickedFace);
                    probeState = level.getBlockState(probePos);
                }
            }
            acb = targetAcb;
        }
        if ((booleanProperty = acb.getGlueableSide(state, clickedFace)) == null) {
            return;
        }
        CCGUtil.sendToServer((CustomPacketPayload)new RadialWrenchMenuSubmitPacket(pos, (BlockState)state.cycle((Property)booleanProperty)));
        CCGUtil.mc.player.swing(CCGUtil.mc.player.getUsedItemHand());
    }

    public static void tableCloth() {
        if (!CCG.CONFIG.goggles.betterStoreInfo) {
            return;
        }
        if (CCGUtil.mc.player == null) {
            return;
        }
        int currentTick = CCGUtil.mc.player.tickCount;
        if ((long)currentTick == lastTick) {
            return;
        }
        lastTick = currentTick;
        TableClothBlockEntity tcbe = CCGUtil.getBlockEntity(TableClothBlockEntity.class);
        if (tcbe == null) {
            return;
        }
        if (TableClothUtil.getItems(tcbe).size() <= 1) {
            return;
        }
        LangBuilder builder = CCGLang.translate("message.toggleItemOverlay", CCGKey.toggleItemOverlay.getFancyName()).style(ChatFormatting.WHITE);
        TipOverlay.show(List.of(builder.component()), 0, 25);
    }

    public static void showCommonTip(String title) {
        if (CCGUtil.hasItemInHand()) {
            return;
        }
        ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
        CCGLang.translate(title, new Object[0]).addTo(tip);
        CCGLang.translate("message.useSwitchState", CCGKey.getFancyName(CCGUtil.mc.options.keyUse)).addTo(tip);
        CCGLang.translate("message.pressToInteractOpposite", CCGKey.interactOpposite.getFancyName()).addTo(tip);
        TipOverlay.show(tip);
    }

    static {
        dismantleDelay = 10L;
    }
}

