/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.commands.PermissionLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public class StructureCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.literal((String)"structure").requires((Predicate)PermissionLevel.GAMEMASTER);
        root.executes(StructureCommand.withPosition(StructureCommand::structureAt, ctx -> ((CommandSourceStack)ctx.getSource()).getEntity().blockPosition()));
        root.then(Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).executes(StructureCommand.withPosition(StructureCommand::structureAt, ctx -> BlockPosArgument.getBlockPos((CommandContext)ctx, (String)"position"))));
        return root;
    }

    private static Set<ResourceLocation> getUniqueStructuresAt(CommandContext<CommandSourceStack> context, BlockPos pos) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
        return level.structureManager().startsForStructure(new ChunkPos(pos), s -> true).stream().filter(s -> s.getBoundingBox().isInside((Vec3i)pos)).map(s -> registry.getKey((Object)s.getStructure())).collect(Collectors.toSet());
    }

    private static int structureAt(CommandContext<CommandSourceStack> context, BlockPos pos) {
        Set<ResourceLocation> structures = StructureCommand.getUniqueStructuresAt(context, pos);
        if (structures.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.bookshelf.structure.error.no_structures"));
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"commands.bookshelf.structure.found", (Object[])new Object[]{structures.size()}).append((Component)Component.literal((String)("\n  " + structures.stream().map(ResourceLocation::toString).collect(Collectors.joining("\n  "))))), false);
        }
        return structures.size();
    }

    private static Command<CommandSourceStack> withPosition(BiFunction<CommandContext<CommandSourceStack>, BlockPos, Integer> cmd, Function<CommandContext<CommandSourceStack>, BlockPos> provider) {
        return ctx -> (Integer)cmd.apply(ctx, (BlockPos)provider.apply(ctx));
    }
}

