/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ServerBoundSetTextHolderPacket
implements Message {
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundSetTextHolderPacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("c2s_set_text_holder"), ServerBoundSetTextHolderPacket::new);
    private final BlockPos pos;
    public final String[][] textHolderLines;

    public ServerBoundSetTextHolderPacket(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.textHolderLines = new String[buf.readVarInt()][];
        for (int i = 0; i < this.textHolderLines.length; ++i) {
            String[] lines = new String[buf.readVarInt()];
            for (int j = 0; j < lines.length; ++j) {
                lines[j] = buf.readUtf();
            }
            this.textHolderLines[i] = lines;
        }
    }

    public ServerBoundSetTextHolderPacket(BlockPos pos, String[][] holderLines) {
        this.pos = pos;
        this.textHolderLines = holderLines;
    }

    public ServerBoundSetTextHolderPacket(BlockPos pos, String[] lines) {
        this(pos, new String[][]{lines});
    }

    public ServerBoundSetTextHolderPacket(BlockPos pos, String line) {
        this(pos, new String[]{line});
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeVarInt(this.textHolderLines.length);
        for (String[] l : this.textHolderLines) {
            buf.writeVarInt(l.length);
            for (String v : l) {
                buf.writeUtf(v);
            }
        }
    }

    public void handle(Message.Context context) {
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer sender = (ServerPlayer)player;
            CompletableFuture.supplyAsync(() -> Stream.of(this.textHolderLines).map(line -> Stream.of(line).map(ChatFormatting::stripFormatting).toList()).map(innerList -> sender.connection.filterTextPacket(innerList)).map(CompletableFuture::join).toList()).thenAcceptAsync(l -> this.updateSignText(sender, (List<List<FilteredText>>)l), (Executor)sender.server);
        }
    }

    private void updateSignText(ServerPlayer player, List<List<FilteredText>> filteredText) {
        ITextHolderProvider te;
        BlockEntity blockEntity;
        player.resetLastActionTime();
        Level level = player.level();
        if (level.hasChunkAt(this.pos) && (blockEntity = level.getBlockEntity(this.pos)) instanceof ITextHolderProvider && (te = (ITextHolderProvider)blockEntity).tryAcceptingClientText(this.pos, player, filteredText)) {
            BlockEntity be = (BlockEntity)te;
            be.setChanged();
            level.sendBlockUpdated(be.getBlockPos(), be.getBlockState(), be.getBlockState(), 3);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

