/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.Objects;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.IMapDisplay;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public record ServerBoundRequestMapDataPacket(BlockPos pos, UUID id) implements Message
{
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundRequestMapDataPacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("c2s_request_map_data"), ServerBoundRequestMapDataPacket::new);

    public ServerBoundRequestMapDataPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readBlockPos(), buf.readUUID());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeUUID(this.id);
    }

    public void handle(Message.Context context) {
        Player player;
        Level level = Objects.requireNonNull(context.getPlayer()).level();
        if (level instanceof ServerLevel && (player = level.getPlayerByUUID(this.id)) instanceof ServerPlayer) {
            IMapDisplay tile;
            ItemStack stack;
            Item item;
            BlockEntity blockEntity;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level.hasChunkAt(this.pos) && (blockEntity = level.getBlockEntity(this.pos)) instanceof IMapDisplay && (item = (stack = (tile = (IMapDisplay)blockEntity).getMapStack()).getItem()) instanceof MapItem) {
                MapItem map = (MapItem)item;
                MapItemSavedData data = MapItem.getSavedData((ItemStack)stack, (Level)level);
                if (data != null) {
                    data.tickCarriedBy(player, stack);
                    map.update(level, (Entity)player, data);
                    Packet updatePacket = map.getUpdatePacket(stack, level, player);
                    if (updatePacket != null) {
                        serverPlayer.connection.send(updatePacket);
                    }
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

