/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.mehvahdjukaar.supplementaries.common.items.components.SelectableContainerContent;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class QuiverContent
extends SelectableContainerContent<Mutable> {
    public static final Codec<QuiverContent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("items").forGetter(SelectableContainerContent::getContentCopy), (App)Codec.INT.fieldOf("selected_slot").forGetter(SelectableContainerContent::getSelectedSlot)).apply((Applicative)instance, QuiverContent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, QuiverContent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, SelectableContainerContent::getContentCopy, (StreamCodec)ByteBufCodecs.INT, SelectableContainerContent::getSelectedSlot, QuiverContent::new);

    QuiverContent(List<ItemStack> stacks, int selected) {
        super(stacks, selected);
    }

    public static QuiverContent empty(int count) {
        return new QuiverContent((List<ItemStack>)NonNullList.withSize((int)count, (Object)ItemStack.EMPTY), 0);
    }

    @Override
    public ItemStack getSelected() {
        return this.getSelected(null);
    }

    public ItemStack getSelected(@Nullable Predicate<ItemStack> supporterArrows) {
        if (supporterArrows == null) {
            return super.getSelected();
        }
        List<ItemStack> content = this.getContentUnsafe();
        int size = content.size();
        for (int i = 0; i < size; ++i) {
            ItemStack s = content.get((i + this.selectedSlot) % size);
            if (!supporterArrows.test(s)) continue;
            return s.copy();
        }
        return ItemStack.EMPTY;
    }

    @Override
    public Mutable toMutable() {
        return new Mutable(this);
    }

    public static class Mutable
    extends SelectableContainerContent.Mut<QuiverContent> {
        protected Mutable(SelectableContainerContent<?> original) {
            super(original);
        }

        @Override
        public QuiverContent toImmutable() {
            this.updateSelectedIfNeeded();
            return new QuiverContent((List<ItemStack>)this.stacks, this.selectedSlot);
        }

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            return QuiverItem.canAcceptItem(stack);
        }
    }
}

