/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.misc.songs.SongsManager;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundFluteParrotsPacket;
import net.mehvahdjukaar.supplementaries.common.utils.VibeChecker;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public abstract class SongInstrumentItem
extends Item {
    protected SongInstrumentItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.NONE;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        VibeChecker.assertSameLevel(level, player);
        player.startUsingItem(hand);
        if (!level.isClientSide) {
            NetworkHelper.sendToAllClientPlayersTrackingEntityAndSelf((Entity)player, (Message)new ClientBoundFluteParrotsPacket((Entity)player, true));
        }
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (!level.isClientSide) {
            SongsManager.playRandomSong(stack, this, entity, this.getUseDuration(stack, entity) - remainingUseDuration);
            if (remainingUseDuration % 10 == 0) {
                level.gameEvent((Entity)entity, (Holder)GameEvent.INSTRUMENT_PLAY, entity.position());
            }
        }
    }

    public void releaseUsing(ItemStack pStack, Level pLevel, LivingEntity entity, int pTimeCharged) {
        SongsManager.clearCurrentlyPlaying(entity.getUUID());
        if (!pLevel.isClientSide) {
            NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new ClientBoundFluteParrotsPacket((Entity)entity, false));
        }
    }

    public float getPitch(int note) {
        return (float)Math.pow(2.0, (double)(note - 1 - 12) / 12.0);
    }

    public float getVolume() {
        return 1.0f;
    }

    public SoundEvent getSound() {
        return (SoundEvent)SoundEvents.NOTE_BLOCK_FLUTE.value();
    }

    public void spawnNoteParticle(Level level, LivingEntity entity, int note) {
    }
}

