/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events.overrides;

import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.supplementaries.common.events.overrides.ItemUseOnBlockBehavior;
import net.mehvahdjukaar.supplementaries.common.items.AntiqueInkItem;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.phys.BlockHitResult;

class AntiqueInkBehavior
implements ItemUseOnBlockBehavior {
    AntiqueInkBehavior() {
    }

    @Override
    public boolean altersWorld() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return AntiqueInkItem.isEnabled();
    }

    @Override
    public boolean appliesToItem(Item item) {
        return item == Items.INK_SAC || item == ModRegistry.ANTIQUE_INK.get();
    }

    @Override
    public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        IOwnerProtected op;
        boolean newState = !stack.is(Items.INK_SAC);
        BlockPos pos = hit.getBlockPos();
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile != null && (!(tile instanceof IOwnerProtected) || (op = (IOwnerProtected)tile).isAccessibleBy(player)) && !(tile instanceof SignBlockEntity) && AntiqueInkItem.toggleAntiqueInkOnSigns(world, player, pos, tile, newState)) {
            stack.consume(1, (LivingEntity)player);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }
}

