/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jetbrains.annotations.Nullable;

public class ShowWaresGoal
extends LookAtPlayerGoal {
    protected final AbstractVillager villager;
    private Player player;
    private final int minDuration;
    private final int maxDuration;
    private final List<ItemStack> displayItems = Lists.newArrayList();
    @Nullable
    private ItemStack playerItemStack;
    private int cycleCounter;
    private int displayIndex;
    private int lookTime;

    public ShowWaresGoal(AbstractVillager mob, int minDuration, int maxDuration) {
        super((Mob)mob, Player.class, 8.0f);
        this.villager = mob;
        this.minDuration = minDuration;
        this.maxDuration = maxDuration;
    }

    public boolean canUse() {
        if (!this.villager.isTrading()) {
            return super.canUse();
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (!this.lookAt.isAlive()) {
            return false;
        }
        if (this.villager.isTrading()) {
            return false;
        }
        if (this.mob.distanceToSqr(this.lookAt) > (double)(this.lookDistance * this.lookDistance)) {
            return false;
        }
        return this.lookTime > 0;
    }

    public void start() {
        this.lookTime = 40;
        this.cycleCounter = 0;
        this.displayIndex = 0;
        this.player = (Player)this.lookAt;
    }

    public void tick() {
        this.findItemsToDisplay();
        if (!this.displayItems.isEmpty()) {
            this.displayCyclingItems();
        } else {
            this.villager.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
        --this.lookTime;
        super.tick();
    }

    public void stop() {
        super.stop();
        this.villager.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        this.playerItemStack = null;
    }

    private void findItemsToDisplay() {
        boolean flag = false;
        ItemStack handStack = this.player.getMainHandItem();
        if (this.playerItemStack == null || !ItemStack.isSameItem((ItemStack)this.playerItemStack, (ItemStack)handStack)) {
            this.playerItemStack = handStack;
            flag = true;
            this.displayItems.clear();
        }
        if (flag && !this.playerItemStack.isEmpty()) {
            this.updateDisplayItems();
            if (!this.displayItems.isEmpty()) {
                this.lookTime = 900;
                this.displayFirstItem();
            }
        }
    }

    private void displayFirstItem() {
        this.villager.setItemSlot(EquipmentSlot.MAINHAND, this.displayItems.get(0));
    }

    private void updateDisplayItems() {
        for (MerchantOffer merchantoffer : this.villager.getOffers()) {
            if (merchantoffer.isOutOfStock() || !this.playerItemStackMatchesCostOfOffer(merchantoffer)) continue;
            this.displayItems.add(merchantoffer.getResult());
        }
    }

    private boolean playerItemStackMatchesCostOfOffer(MerchantOffer offer) {
        return ItemStack.isSameItem((ItemStack)this.playerItemStack, (ItemStack)offer.getCostA()) || ItemStack.isSameItem((ItemStack)this.playerItemStack, (ItemStack)offer.getCostB());
    }

    private void displayCyclingItems() {
        if (this.displayItems.size() >= 2 && ++this.cycleCounter >= 40) {
            ++this.displayIndex;
            this.cycleCounter = 0;
            if (this.displayIndex > this.displayItems.size() - 1) {
                this.displayIndex = 0;
            }
            this.mob.setItemSlot(EquipmentSlot.MAINHAND, this.displayItems.get(this.displayIndex));
        }
    }
}

