/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.supplementaries.common.block.blocks.AwningBlock;
import net.mehvahdjukaar.supplementaries.common.entities.data.SlimedData;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SlimeBallEntity
extends ImprovedProjectileEntity {
    private int bounces = 0;

    public SlimeBallEntity(Level world, double x, double y, double z) {
        super(ModEntities.THROWABLE_SLIMEBALL.get(), x, y, z, world);
        this.maxAge = 400;
    }

    public SlimeBallEntity(LivingEntity thrower) {
        super(ModEntities.THROWABLE_SLIMEBALL.get(), thrower, thrower.level());
        this.maxAge = 400;
    }

    public SlimeBallEntity(EntityType<SlimeBallEntity> type, Level level) {
        super(type, level);
        this.maxAge = 400;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("bounces", this.bounces);
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        this.bounces = compound.getInt("bounces");
    }

    protected Component getTypeName() {
        return this.getItem().getDisplayName();
    }

    protected Item getDefaultItem() {
        return Items.SLIME_BALL;
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        Direction hitDirection = result.getDirection();
        Vector3f surfaceNormal = hitDirection.step();
        BlockState hitState = this.level().getBlockState(result.getBlockPos());
        if (hitDirection == Direction.UP && hitState.getBlock() instanceof AwningBlock) {
            surfaceNormal = AwningBlock.getNormalVector(hitState);
        }
        Vec3 velocity = this.getDeltaMovement();
        Vec3 newVel = new Vec3(velocity.toVector3f().reflect((Vector3fc)surfaceNormal));
        this.bounce(newVel);
    }

    private void bounce(Vec3 newVel) {
        ++this.bounces;
        Vec3 velocity = this.getDeltaMovement();
        float conservedEnergy = 0.75f;
        newVel = newVel.scale((double)conservedEnergy);
        this.setDeltaMovement(newVel);
        double missingDistance = velocity.subtract(this.position().subtract(new Vec3(this.xo, this.yo, this.zo))).length();
        Vec3 missingVel = newVel.normalize().scale(missingDistance);
        this.move(MoverType.SELF, missingVel);
        if (!this.level().isClientSide) {
            this.hasImpulse = true;
            this.addParticleEffects();
            this.playSound(ModSounds.SLIMEBALL_LAND.get(), 1.5f, 1.0f);
            if (this.bounces > 3) {
                this.discard();
            }
        }
    }

    private void addParticleEffects() {
        this.level().broadcastEntityEvent((Entity)this, (byte)3);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ItemParticleOption particleOptions = new ItemParticleOption(ParticleTypes.ITEM, this.getItem());
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)particleOptions, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity le;
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity && (le = (LivingEntity)entity).isBlocking()) {
            Vec3 hit = result.getLocation();
            Vec3 entityView = le.getViewVector(1.0f);
            Vec3 normal = hit.vectorTo(le.position()).normalize();
            normal = new Vec3(normal.x, 0.0, normal.z);
            if (normal.dot(entityView) < 0.0) {
                this.bounce(this.getDeltaMovement().scale(-1.0));
                return;
            }
        }
        if (entity instanceof LivingEntity && (le = (LivingEntity)entity).attackable()) {
            SlimedData slimedData = (SlimedData)ModRegistry.SLIMED_DATA.getOrCreate((Object)le);
            slimedData.setSlimedTicks(le, CommonConfigs.Tweaks.SLIME_DURATION.get());
        } else if (entity instanceof EndCrystal) {
            entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
        } else {
            this.hasImpulse = true;
            this.addParticleEffects();
        }
        this.discard();
    }

    public float getDefaultShootVelocity() {
        return 1.25f;
    }

    public boolean canHarmOwner() {
        return true;
    }
}

