/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import net.mehvahdjukaar.moonlight.api.entity.IControllableVehicle;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonController;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CannonBlock;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.CannonContainerMenu;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSendKnockbackPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundUpdateCannonBoatPacket;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundRequestOpenCannonGuiMessage;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSyncCannonPacket;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CannonBoatEntity
extends Boat
implements HasCustomInventoryScreen,
ContainerEntity,
CannonAccess,
IControllableVehicle {
    private static final EntityDataAccessor<WoodType> DATA_WOOD_TYPE = SynchedEntityData.defineId(CannonBoatEntity.class, (EntityDataSerializer)((EntityDataSerializer)WoodType.ENTITY_SERIALIZER.get()));
    private static final EntityDataAccessor<ItemStack> BANNER_ITEM = SynchedEntityData.defineId(CannonBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private final CannonBlockTile cannon = new CannonBlockTile(BlockPos.ZERO, (BlockState)ModRegistry.CANNON.get().defaultBlockState().setValue((Property)CannonBlock.FACING, (Comparable)Direction.UP));
    private boolean isBamboo;

    public CannonBoatEntity(EntityType<CannonBoatEntity> entityType, Level level) {
        super(entityType, level);
        this.cannon.setLevel(level);
        this.cannon.setRenderYaw(this, 0.0f);
        this.setWoodType(VanillaWoodTypes.OAK);
    }

    public CannonBoatEntity(Level level, double x, double y, double z, WoodType type) {
        this(ModEntities.CANNON_BOAT.get(), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setWoodType(type);
        this.setVariant(type.toVanillaBoatOrOak());
    }

    public boolean isBamboo() {
        return this.isBamboo;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_WOOD_TYPE, (Object)VanillaWoodTypes.OAK);
        builder.define(BANNER_ITEM, (Object)ItemStack.EMPTY);
    }

    public ItemStack getBannerItem() {
        return (ItemStack)this.entityData.get(BANNER_ITEM);
    }

    public void setBannerItem(ItemStack stack) {
        this.entityData.set(BANNER_ITEM, (Object)stack);
    }

    public void setWoodType(WoodType type) {
        this.entityData.set(DATA_WOOD_TYPE, (Object)type);
        this.isBamboo = type.getId().toString().equals("minecraft:bamboo");
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        super.onSyncedDataUpdated(dataAccessor);
        if (dataAccessor == DATA_WOOD_TYPE) {
            this.isBamboo = this.getWoodType().getId().toString().equals("minecraft:bamboo");
        }
    }

    public WoodType getWoodType() {
        return (WoodType)this.entityData.get(DATA_WOOD_TYPE);
    }

    protected float getSinglePassengerXOffset() {
        return 0.275f;
    }

    protected int getMaxPassengers() {
        return 1;
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("WoodType", this.getWoodType().getId().toString());
        CompoundTag cannonTag = this.cannon.saveWithoutMetadata((HolderLookup.Provider)this.registryAccess());
        compound.put("Cannon", (Tag)cannonTag);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        String woodTypeId = compound.getString("WoodType");
        this.setWoodType((WoodType)WoodTypeRegistry.INSTANCE.get(ResourceLocation.parse((String)woodTypeId)));
        if (compound.contains("Cannon")) {
            CompoundTag cannonTag = compound.getCompound("Cannon");
            this.cannon.loadWithComponents(cannonTag, (HolderLookup.Provider)this.registryAccess());
        }
    }

    public void destroy(DamageSource source) {
        this.destroy(this.getDropItem());
        this.chestVehicleDestroyed(source, this.level(), (Entity)this);
        ItemStack bannerItem = this.getBannerItem();
        if (!bannerItem.isEmpty()) {
            this.spawnAtLocation(bannerItem);
        }
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide && reason.shouldDestroy()) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
        }
        super.remove(reason);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        InteractionResult interactionResult;
        if (!player.isSecondaryUseActive()) {
            interactionResult = super.interact(player, hand);
            if (interactionResult != InteractionResult.PASS) {
                return interactionResult;
            }
        } else {
            ItemStack item = player.getItemInHand(hand);
            boolean hasNoBanner = this.getBannerItem().isEmpty();
            if (hasNoBanner && item.is(ItemTags.BANNERS)) {
                this.setBannerItem(item.copy());
                if (!player.getAbilities().instabuild) {
                    item.shrink(1);
                }
                this.playSound(((BlockItem)item.getItem()).getBlock().defaultBlockState().getSoundType().getPlaceSound(), 1.0f, 1.2f);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        if (this.canAddPassenger((Entity)player) && !player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        interactionResult = this.interactWithContainerVehicle(player);
        if (interactionResult.consumesAction()) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return interactionResult;
    }

    public InteractionResult interactWithContainerVehicle(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PlatHelper.openCustomMenu((ServerPlayer)sp, (Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public Item getDropItem() {
        return (Item)ModRegistry.CANNON_BOAT_ITEMS.get(this.getWoodType());
    }

    public void clearContent() {
        this.cannon.clearContent();
    }

    public int getContainerSize() {
        return this.cannon.getContainerSize();
    }

    public ItemStack getItem(int slot) {
        return this.cannon.getItem(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.cannon.removeItem(slot, amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.cannon.removeItemNoUpdate(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.cannon.setItem(slot, stack);
    }

    public SlotAccess getSlot(int slot) {
        return this.getChestVehicleSlot(slot);
    }

    public void setChanged() {
        this.cannon.setChanged();
    }

    @Override
    public boolean stillValid(Player player) {
        return this.isChestVehicleStillValid(player);
    }

    @Override
    public void openCannonGui(ServerPlayer player) {
        PlatHelper.openCustomMenu((ServerPlayer)player, (Entity)this);
    }

    public void openCustomInventoryScreen(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.openCannonGui(sp);
        }
        if (!player.level().isClientSide) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        if (inv.player.isSpectator()) {
            return null;
        }
        return new CannonContainerMenu(id, inv, this);
    }

    @Nullable
    public ResourceKey<LootTable> getLootTable() {
        return this.cannon.getLootTable();
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> lootTable) {
        this.cannon.setLootTable(lootTable);
    }

    public long getLootTableSeed() {
        return this.cannon.getLootTableSeed();
    }

    public void setLootTableSeed(long lootTableSeed) {
        this.cannon.setLootTableSeed(lootTableSeed);
    }

    public NonNullList<ItemStack> getItemStacks() {
        return this.cannon.getItems();
    }

    public void clearItemStacks() {
        this.cannon.clearContent();
    }

    public void stopOpen(Player player) {
        this.cannon.stopOpen(player);
    }

    @Override
    public CannonBlockTile getInternalCannon() {
        return this.cannon;
    }

    @Override
    public TileOrEntityTarget makeNetworkTarget() {
        return TileOrEntityTarget.of((Entity)this);
    }

    @Override
    public void syncToServer(boolean fire, boolean removeOwner) {
        NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundSyncCannonPacket(this.cannon.getYaw(), this.cannon.getPitch(), this.cannon.getPowerLevel(), fire, false, TileOrEntityTarget.of((Entity)this)));
    }

    @Override
    public void sendOpenGuiRequest() {
        NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundRequestOpenCannonGuiMessage((Entity)this));
    }

    @Override
    public Vec3 getCannonGlobalOffset() {
        if (this.isBamboo) {
            float backOff = 0.375f;
            return new Vec3(0.0, 1.0, (double)backOff);
        }
        float backOff = 0.4375f;
        return new Vec3(0.0, 0.75, (double)backOff);
    }

    @Override
    public Vec3 getCannonGlobalPosition(float partialTicks) {
        float yaw = this.getCannonGlobalYawOffset(partialTicks);
        Vec3 vv = this.getCannonGlobalOffset();
        vv = vv.yRot((float)Math.PI / 180 * yaw);
        return this.getPosition(partialTicks).add(vv);
    }

    protected void positionRider(Entity passenger, Entity.MoveFunction callback) {
        super.positionRider(passenger, callback);
    }

    protected void clampRotation(Entity entityToUpdate) {
        if (entityToUpdate instanceof AbstractIllager) {
            return;
        }
        super.clampRotation(entityToUpdate);
    }

    @Override
    public float getCannonGlobalYawOffset(float partialTicks) {
        return 180.0f - this.getViewYRot(partialTicks);
    }

    @Override
    public void updateClients() {
        NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new ClientBoundUpdateCannonBoatPacket(TileOrEntityTarget.of((Entity)this), this.cannon.saveWithoutMetadata((HolderLookup.Provider)this.registryAccess())));
    }

    @Override
    public CannonAccess.Restraint getPitchAndYawRestrains() {
        return new CannonAccess.Restraint(50.0f, 310.0f, 0.0f, 180.0f);
    }

    @Override
    public Vec3 getCannonGlobalVelocity() {
        return this.getDeltaMovement();
    }

    public void onInputUpdate(boolean b, boolean b1, boolean b2, boolean b3, boolean ctrl, boolean jump) {
        if (jump && this.level().isClientSide) {
            CannonController.startControlling(this);
        }
        if (ctrl && this.cannon.readyToFire()) {
            this.syncToServer(true, false);
        }
    }

    @Override
    public boolean canManeuverFromGUI(Player player) {
        return this.getControllingPassenger() == player;
    }

    public void tick() {
        super.tick();
        this.cannon.tick(this);
    }

    protected void addPassenger(Entity passenger) {
        super.addPassenger(passenger);
        if (passenger instanceof Player) {
            Player player = (Player)passenger;
            this.cannon.setPlayerWhoMayEdit(player.getUUID());
        }
    }

    protected void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        this.cannon.setPlayerWhoMayEdit(null);
    }

    @Override
    public void applyRecoil() {
        Vec3 v = this.getCannonRecoil();
        if (this.hasControllingPassenger()) {
            NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new ClientBoundSendKnockbackPacket(this.getId(), v));
        } else {
            this.addDeltaMovement(v);
        }
    }

    @Override
    @NotNull
    public Vec3 getCannonRecoil() {
        float power = this.cannon.getFirePower();
        float scale = 1.0f;
        Vec3 shootForce = this.getCannonGlobalFacing(1.0f).scale((double)(power * scale));
        return new Vec3(-shootForce.x, 0.0, -shootForce.z);
    }

    @Override
    public boolean shouldRotatePlayerFaceWhenManeuvering() {
        return true;
    }

    @Override
    public boolean impedePlayerMovementWhenManeuvering() {
        return false;
    }
}

