/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOnePlayerInteractable;
import net.mehvahdjukaar.moonlight.api.block.IWaxable;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.screens.BlackBoardScreen;
import net.mehvahdjukaar.supplementaries.common.block.IGlowable;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.items.components.BlackboardData;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BlackboardBlockTile
extends BlockEntity
implements IOnePlayerInteractable,
IScreenProvider,
IWaxable,
IGlowable,
IExtraModelDataProvider {
    public static final ModelDataKey<BlackboardData> BLACKBOARD_KEY = ModBlockProperties.BLACKBOARD;
    @Nullable
    private UUID playerWhoMayEdit = null;
    private BlackboardData data = BlackboardData.EMPTY;

    public BlackboardBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.BLACKBOARD_TILE.get(), pos, state);
        this.clearPixels();
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(BLACKBOARD_KEY, (Object)this.data);
    }

    public void setChanged() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        super.setChanged();
    }

    public boolean tryOpeningEditGui(ServerPlayer player, BlockPos pos, ItemStack stack, Direction hitFace) {
        if (this.isWaxed()) {
            return false;
        }
        return super.tryOpeningEditGui(player, pos, stack, hitFace);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("Waxed") || tag.contains("Pixels")) {
            boolean waxed = tag.contains("Waxed") && tag.getBoolean("Waxed");
            byte[][] pixels = new byte[16][16];
            if (tag.contains("Pixels")) {
                pixels = BlackboardData.unpackPixels(tag.getLongArray("Pixels"));
            }
            this.data = new BlackboardData(pixels, false, waxed);
        } else if (tag.contains("values")) {
            RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            this.data = (BlackboardData)BlackboardData.CODEC.parse((DynamicOps)ops, (Object)tag).getOrThrow();
        }
        this.requestModelReload();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.data.equals(BlackboardData.EMPTY)) {
            RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            tag.merge((CompoundTag)BlackboardData.CODEC.encodeStart((DynamicOps)ops, (Object)this.data).getOrThrow());
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        if (!this.isEmpty()) {
            components.set(ModComponents.BLACKBOARD.get(), (Object)this.data);
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        BlackboardData data = (BlackboardData)componentInput.get(ModComponents.BLACKBOARD.get());
        if (data != null) {
            this.data = data;
        } else {
            this.clearPixels();
        }
        this.requestModelReload();
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("values");
        tag.remove("glow");
        tag.remove("waxed");
    }

    public void clearPixels() {
        this.data = this.data.makeCleared();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void setPixel(int x, int y, byte b) {
        this.data = this.data.withPixel(x, y, b);
    }

    public byte getPixel(int xx, int yy) {
        return this.data.getPixel(xx, yy);
    }

    public void setPixels(byte[][] pixels) {
        this.data = this.data.withPixels(pixels);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag c = this.saveWithoutMetadata(registries);
        if (c.isEmpty()) {
            c.putBoolean("Empty", true);
        }
        return c;
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)NoticeBoardBlock.FACING);
    }

    public void openScreen(Level level, Player player, Direction direction) {
        BlackBoardScreen.open(this);
    }

    public void setWaxed(boolean b) {
        this.data = this.data.withWaxed(b);
    }

    public boolean isWaxed() {
        return this.data.isWaxed();
    }

    @Override
    public void setGlowing(boolean b) {
        this.data = this.data.withGlow(b);
    }

    @Override
    public boolean isGlowing() {
        return this.data.isGlow();
    }

    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    public void setPlayerWhoMayEdit(UUID playerWhoMayEdit) {
        this.playerWhoMayEdit = playerWhoMayEdit;
    }

    public boolean tryAcceptingClientPixels(ServerPlayer player, byte[][] pixels) {
        if (!this.isEditingPlayer(this.worldPosition, (Player)player) || this.isWaxed()) {
            Supplementaries.LOGGER.warn("Player {} just tried to change non-editable blackboard block", (Object)player.getName().getString());
        }
        if (!CommonConfigs.Building.BLACKBOARD_COLOR.get().booleanValue()) {
            byte black = BlackboardBlock.colorToByte(DyeColor.BLACK);
            byte white = BlackboardBlock.colorToByte(DyeColor.WHITE);
            byte[][] byArray = pixels;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte[] pixel;
                for (byte b : pixel = byArray[i]) {
                    if (b == black || b == white) continue;
                    Supplementaries.LOGGER.warn("Player {} just tried to change blackboard block with colored pixels", (Object)player.getName().getString());
                    return false;
                }
            }
        }
        if (!this.data.hasSamePixels(pixels)) {
            this.level.playSound(null, this.worldPosition, ModSounds.BLACKBOARD_DRAW.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setPlayerWhoMayEdit(null);
            this.setPixels(pixels);
            return true;
        }
        return false;
    }
}

