/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.fire_behaviors;

import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.GenericProjectileBehavior;
import net.mehvahdjukaar.supplementaries.common.utils.fake_level.IEntityInterceptFakeLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SimpleProjectileBehavior<T extends Projectile>
extends GenericProjectileBehavior {
    private final EntityType<T> entityType;
    private final float initialSpeed;

    public SimpleProjectileBehavior(EntityType<T> entityType, float initialSpeed) {
        this.entityType = entityType;
        this.initialSpeed = initialSpeed;
    }

    @Override
    @Nullable
    public Entity createEntity(ItemStack stack, IEntityInterceptFakeLevel testLevel, Vec3 facing) {
        Projectile e = (Projectile)this.entityType.create(testLevel.cast());
        e.setDeltaMovement(facing.normalize().scale((double)this.initialSpeed));
        if (e instanceof ThrowableItemProjectile) {
            ThrowableItemProjectile ip = (ThrowableItemProjectile)e;
            ip.setItem(stack);
        }
        return e;
    }
}

