/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.dispenser;

import net.mehvahdjukaar.moonlight.api.util.DispenserHelper;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IFireItemBehavior;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class FireBehaviorProxy
extends DispenserHelper.AdditionalDispenserBehavior {
    private final IFireItemBehavior inner;
    private final float power;
    private final int uncertainty;
    private final boolean hasSound;

    public FireBehaviorProxy(Item item, IFireItemBehavior inner, float power, int uncertainty, boolean hasSound) {
        super(item);
        this.inner = inner;
        this.power = power;
        this.uncertainty = uncertainty;
        this.hasSound = hasSound;
    }

    protected InteractionResultHolder<ItemStack> customBehavior(BlockSource source, ItemStack stack) {
        ServerLevel level = source.level();
        Position position = DispenserBlock.getDispensePosition((BlockSource)source);
        Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        Vec3 firePos = new Vec3(position.x(), position.y(), position.z());
        if (this.inner.fire(stack, level, firePos, new Vec3(direction.step()), this.power, this.uncertainty, null)) {
            stack.shrink(1);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    protected void playSound(BlockSource source, boolean success) {
        if (this.hasSound) {
            super.playSound(source, success);
        }
    }
}

