/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PedestalBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.SackItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PedestalBlock
extends WaterBlock
implements EntityBlock,
WorldlyContainerHolder {
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.125, (double)0.1875, (double)0.815, (double)0.885, (double)0.815), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.0625, (double)0.8125, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375), Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.9375)});
    protected static final VoxelShape SHAPE_UP = Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.125, (double)0.1875, (double)0.815, (double)1.0, (double)0.815), (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.9375));
    protected static final VoxelShape SHAPE_DOWN = Shapes.or((VoxelShape)Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.815, (double)0.885, (double)0.815), (VoxelShape)Shapes.box((double)0.0625, (double)0.8125, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375));
    protected static final VoxelShape SHAPE_UP_DOWN = Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.815, (double)1.0, (double)0.815);
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final EnumProperty<ModBlockProperties.DisplayStatus> ITEM_STATUS = ModBlockProperties.ITEM_STATUS;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;

    public PedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(ITEM_STATUS, (Comparable)((Object)ModBlockProperties.DisplayStatus.EMPTY)));
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        PedestalBlockTile te;
        BlockEntity blockEntity;
        double power = CommonConfigs.Building.CRYSTAL_ENCHANTING.get();
        if (power != 0.0 && (blockEntity = world.getBlockEntity(pos)) instanceof PedestalBlockTile && (te = (PedestalBlockTile)blockEntity).getDisplayType() == PedestalBlockTile.DisplayType.CRYSTAL) {
            return (float)power;
        }
        return 0.0f;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, WATERLOGGED, ITEM_STATUS, AXIS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        boolean flag = level.getFluidState(pos = context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).setValue(AXIS, (Comparable)context.getHorizontalDirection().getAxis())).setValue(ITEM_STATUS, (Comparable)((Object)PedestalBlock.getStatus((LevelAccessor)level, pos, false)))).setValue((Property)UP, (Comparable)Boolean.valueOf(PedestalBlock.canConnectTo(level.getBlockState(pos.above()), pos, (LevelAccessor)level, Direction.UP, false)))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(PedestalBlock.canConnectTo(level.getBlockState(pos.below()), pos, (LevelAccessor)level, Direction.DOWN, false)));
    }

    public static boolean canConnectTo(BlockState state, BlockPos pos, LevelAccessor world, Direction dir, boolean hasItem) {
        if (state.getBlock() instanceof PedestalBlock) {
            if (dir == Direction.DOWN) {
                return !((ModBlockProperties.DisplayStatus)((Object)state.getValue(ITEM_STATUS))).hasTile();
            }
            if (dir == Direction.UP) {
                return !hasItem;
            }
        }
        return false;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
        if (facing == Direction.UP) {
            boolean hasItem = ((ModBlockProperties.DisplayStatus)((Object)stateIn.getValue(ITEM_STATUS))).hasItem();
            return (BlockState)((BlockState)stateIn.setValue(ITEM_STATUS, (Comparable)((Object)PedestalBlock.getStatus(level, currentPos, hasItem)))).setValue((Property)UP, (Comparable)Boolean.valueOf(PedestalBlock.canConnectTo(facingState, currentPos, level, facing, hasItem)));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.setValue((Property)DOWN, (Comparable)Boolean.valueOf(PedestalBlock.canConnectTo(facingState, currentPos, level, facing, ((ModBlockProperties.DisplayStatus)((Object)stateIn.getValue(ITEM_STATUS))).hasItem())));
        }
        return stateIn;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        ItemDisplayTile tile;
        ItemStack i;
        BlockEntity blockEntity;
        if (target.getLocation().y() > (double)(pos.getY() + 1) - 0.1875 && (blockEntity = world.getBlockEntity(pos)) instanceof ItemDisplayTile && !(i = (tile = (ItemDisplayTile)blockEntity).getDisplayedItem()).isEmpty()) {
            return i;
        }
        return super.getCloneItemStack(world, pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        ItemInteractionResult resultType = ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        if (((ModBlockProperties.DisplayStatus)((Object)state.getValue(ITEM_STATUS))).hasTile() && (blockEntity = level.getBlockEntity(pos)) instanceof PedestalBlockTile) {
            PedestalBlockTile tile = (PedestalBlockTile)blockEntity;
            if (stack.getItem() instanceof SackItem) {
                ItemStack it = stack.copy();
                it.setCount(1);
                ItemStack removed = tile.removeItemNoUpdate(0);
                tile.setDisplayedItem(it);
                stack.consume(1, (LivingEntity)player);
                if (!level.isClientSide()) {
                    player.setItemInHand(hand, removed);
                    level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.95f);
                    tile.setChanged();
                } else {
                    tile.updateClientVisualsOnLoad();
                }
                resultType = ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            } else {
                resultType = tile.interactWithPlayerItem(player, hand, stack);
            }
        }
        return resultType;
    }

    public static boolean canHaveItemAbove(LevelAccessor level, BlockPos pos) {
        BlockState above = level.getBlockState(pos.above());
        return !above.is(ModRegistry.PEDESTAL.get()) && !above.isRedstoneConductor((BlockGetter)level, pos.above());
    }

    public static ModBlockProperties.DisplayStatus getStatus(LevelAccessor level, BlockPos pos, boolean hasItem) {
        if (hasItem) {
            return ModBlockProperties.DisplayStatus.FULL;
        }
        return PedestalBlock.canHaveItemAbove(level, pos) ? ModBlockProperties.DisplayStatus.EMPTY : ModBlockProperties.DisplayStatus.NONE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean up = (Boolean)state.getValue((Property)UP);
        boolean down = (Boolean)state.getValue((Property)DOWN);
        if (!up) {
            if (!down) {
                return SHAPE;
            }
            return SHAPE_DOWN;
        }
        if (!down) {
            return SHAPE_UP;
        }
        return SHAPE_UP_DOWN;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        if (((ModBlockProperties.DisplayStatus)((Object)pState.getValue(ITEM_STATUS))).hasTile()) {
            return new PedestalBlockTile(pPos, pState);
        }
        return null;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof PedestalBlockTile) {
            PedestalBlockTile tile = (PedestalBlockTile)blockEntity;
            return tile.isEmpty() ? 0 : 15;
        }
        return 0;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        if (rotation == Rotation.CLOCKWISE_180) {
            return state;
        }
        return switch ((Direction.Axis)state.getValue(AXIS)) {
            case Direction.Axis.Z -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
            case Direction.Axis.X -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
            default -> state;
        };
    }

    public WorldlyContainer getContainer(BlockState state, LevelAccessor level, BlockPos pos) {
        if (((ModBlockProperties.DisplayStatus)((Object)state.getValue(ITEM_STATUS))).hasTile()) {
            return (PedestalBlockTile)level.getBlockEntity(pos);
        }
        return new TileLessContainer(state, level, pos);
    }

    @Deprecated(forRemoval=true)
    static class TileLessContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private PedestalBlockTile tileReference = null;

        public TileLessContainer(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos) {
            super(1);
            this.state = blockState;
            this.level = levelAccessor;
            this.pos = blockPos;
        }

        public boolean stillValid(Player player) {
            return this.tileReference == null;
        }

        public ItemStack getItem(int slot) {
            if (this.tileReference != null) {
                return this.tileReference.getItem(slot);
            }
            return super.getItem(slot);
        }

        public ItemStack removeItem(int slot, int amount) {
            if (this.tileReference != null) {
                return this.tileReference.removeItem(slot, amount);
            }
            return super.removeItem(slot, amount);
        }

        public boolean isEmpty() {
            if (this.tileReference != null) {
                return this.tileReference.isEmpty();
            }
            return super.isEmpty();
        }

        public ItemStack removeItemNoUpdate(int slot) {
            if (this.tileReference != null) {
                return this.tileReference.removeItemNoUpdate(slot);
            }
            return super.removeItemNoUpdate(slot);
        }

        public void clearContent() {
            if (this.tileReference != null) {
                this.tileReference.clearContent();
            } else {
                super.clearContent();
            }
        }

        public boolean canPlaceItem(int index, ItemStack stack) {
            if (this.tileReference != null) {
                return this.tileReference.canPlaceItem(index, stack);
            }
            return super.canPlaceItem(index, stack);
        }

        public int getMaxStackSize() {
            if (this.tileReference != null) {
                return this.tileReference.getMaxStackSize();
            }
            return 1;
        }

        public int[] getSlotsForFace(Direction side) {
            if (this.tileReference != null) {
                return this.tileReference.getSlotsForFace(side);
            }
            return new int[]{0};
        }

        public boolean canPlaceItemThroughFace(int index, ItemStack itemStack, @Nullable Direction direction) {
            if (this.tileReference != null) {
                return this.canTakeItemThroughFace(index, itemStack, direction);
            }
            return true;
        }

        public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
            if (this.tileReference != null) {
                return this.tileReference.canTakeItemThroughFace(index, stack, direction);
            }
            return !this.isEmpty();
        }

        public void setChanged() {
            if (!this.isEmpty()) {
                BlockEntity blockEntity;
                ItemStack item = this.getItem(0);
                if (!item.isEmpty()) {
                    this.level.setBlock(this.pos, (BlockState)this.state.setValue(ITEM_STATUS, (Comparable)((Object)ModBlockProperties.DisplayStatus.EMPTY)), 3);
                }
                if ((blockEntity = this.level.getBlockEntity(this.pos)) instanceof PedestalBlockTile) {
                    PedestalBlockTile tile;
                    this.tileReference = tile = (PedestalBlockTile)blockEntity;
                    tile.setDisplayedItem(item);
                }
            }
        }
    }
}

